/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.statement.CountStatement;
import org.openzen.zengarden.basedao.statement.InsertStatement;
import org.openzen.zengarden.basedao.statement.QueryStatement;
import org.openzen.zengarden.basedao.statement.UpdateStatement;
import org.openzen.zengarden.collections.ZArrayList;
import org.openzen.zengarden.collections.ZList;

public abstract class BaseDAO<U, T> {
    protected final Connection connection;
    protected final String table;
    private final Reader<T> reader;
    private final Class<T> type;

    public BaseDAO(Connection connection, String table, Reader<T> reader, Class<T> type) throws SQLException {
        this.connection = connection;
        this.table = table;
        this.reader = reader;
        this.type = type;
    }

    public ZList<T> getAll() throws SQLException {
        return this.query("SELECT * FROM " + this.table).queryMany();
    }

    public QueryStatement<T> query(String query) {
        return new QueryStatement<T>(this.type, this.connection, query, this.reader);
    }

    public InsertStatement insert(String query) {
        return new InsertStatement(this.connection, query);
    }

    public UpdateStatement update(String query) {
        return new UpdateStatement(this.connection, query);
    }

    public CountStatement count(String query) {
        return new CountStatement(this.connection, query);
    }

    public abstract void insert(U var1, T var2) throws SQLException;

    public abstract void update(U var1, T var2) throws SQLException;

    public void close() throws SQLException {
    }

    protected long getInsertId(PreparedStatement statement) throws SQLException {
        try (ResultSet rs = statement.getGeneratedKeys();){
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        return 0L;
    }

    protected T loadOne(ResultSet rs) throws SQLException {
        try {
            if (rs.next()) {
                T t = this.reader.read(rs);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZList<T> loadAll(ResultSet rs) throws SQLException {
        try {
            ZArrayList results = new ZArrayList(this.type);
            while (rs.next()) {
                results.add(this.reader.read(rs));
            }
            ZArrayList zArrayList = results;
            return zArrayList;
        }
        finally {
            rs.close();
        }
    }

    public static interface Reader<T> {
        public T read(ResultSet var1) throws SQLException;
    }
}

