/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import org.openzen.zengarden.basedao.BaseDAO;
import org.openzen.zengarden.basedao.statement.QueryStatement;
import org.openzen.zengarden.basedao.statement.UpdateStatement;

public abstract class BaseDAOWithUUID<U, T>
extends BaseDAO<U, T> {
    private final QueryStatement<T> getById;
    private final UpdateStatement deleteById;

    public BaseDAOWithUUID(Connection connection, String table, BaseDAO.Reader<T> reader, Class<T> type) throws SQLException {
        super(connection, table, reader, type);
        this.getById = this.query("SELECT * FROM " + table + " WHERE uuid=?");
        this.deleteById = this.update("DELETE FROM " + table + " WHERE uuid=?");
    }

    public T getByUUID(UUID uuid) {
        try {
            this.getById.setUUIDBinary(1, uuid);
            return this.getById.queryFirst();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean delete(U user, UUID uuid) {
        try {
            this.deleteById.setUUIDBinary(1, uuid);
            return this.deleteById.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.getById.close();
        this.deleteById.close();
    }
}

