/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao.statement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.BaseDAO;
import org.openzen.zengarden.basedao.statement.BaseStatement;
import org.openzen.zengarden.collections.ZArrayList;
import org.openzen.zengarden.collections.ZList;

public class QueryStatement<T>
extends BaseStatement {
    private final Class<T> type;
    private final BaseDAO.Reader<T> reader;

    public QueryStatement(Class<T> type, Connection connection, String statement, BaseDAO.Reader<T> reader) {
        super(connection, statement);
        this.type = type;
        this.reader = reader;
    }

    public T queryFirst() throws SQLException {
        return this.loadOne(this.get().executeQuery());
    }

    public ZList<T> queryMany() throws SQLException {
        return this.loadAll(this.get().executeQuery());
    }

    private T loadOne(ResultSet rs) throws SQLException {
        try {
            if (rs.next()) {
                T t = this.reader.read(rs);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZList<T> loadAll(ResultSet rs) throws SQLException {
        try {
            ZArrayList results = new ZArrayList(this.type);
            while (rs.next()) {
                results.add(this.reader.read(rs));
            }
            ZArrayList zArrayList = results;
            return zArrayList;
        }
        finally {
            rs.close();
        }
    }
}

