/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.events;

import org.openzen.zengarden.events.EventListener;
import org.openzen.zengarden.events.ListenerHandle;
import org.openzen.zengarden.events.ListenerList;

public class EventBus<T>
extends ListenerList<EventListener<T>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(T event) {
        ListenerList.EventListenerNode current = this.first;
        while (current != null) {
            ((EventListener)current.listener).onEvent(event);
            EventBus eventBus = this;
            synchronized (eventBus) {
                current = current.next;
            }
        }
    }

    public <E extends T> ListenerHandle<EventListener<T>> add(EventListener<E> listener, Class<E> clazz) {
        return this.add(new SingleEventListener(listener, clazz), 0);
    }

    public <E extends T> ListenerHandle<EventListener<T>> add(EventListener<E> listener, Class<E> clazz, int priority) {
        return this.add(new SingleEventListener(listener, clazz), priority);
    }

    protected static class SingleEventListener<E extends T, T>
    implements EventListener<T> {
        private final Class<E> eventClass;
        private final EventListener<E> wrappedListener;

        public SingleEventListener(EventListener<E> wrappedListener, Class<E> eventClass) {
            this.eventClass = eventClass;
            this.wrappedListener = wrappedListener;
        }

        @Override
        public void onEvent(T event) {
            if (this.eventClass.isInstance(event)) {
                this.wrappedListener.onEvent(event);
            }
        }
    }
}

