/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import org.openzen.zengarden.io.Serializer;
import org.openzen.zengarden.util.Charsets;

public interface DataOutput
extends Closeable {
    default public void writeBoolean(boolean value) throws IOException {
        this.writeUByte(value ? 1 : 0);
    }

    public void writeSByte(byte var1) throws IOException;

    public void writeUByte(int var1) throws IOException;

    public void writeShort(short var1) throws IOException;

    public void writeUShort(int var1) throws IOException;

    public void writeInt(int var1) throws IOException;

    public void writeUInt(int var1) throws IOException;

    public void writeLong(long var1) throws IOException;

    public void writeULong(long var1) throws IOException;

    default public void writeChar(int value) throws IOException {
        this.writeVarUInt(value);
    }

    default public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    default public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeVarInt(int var1) throws IOException;

    public void writeVarUInt(int var1) throws IOException;

    public void writeVarLong(long var1) throws IOException;

    public void writeVarULong(long var1) throws IOException;

    default public void writeBytes(byte[] data) throws IOException {
        this.writeVarUInt(data.length);
        this.writeRawBytes(data);
    }

    default public void writeBytes(byte[] data, int offset, int length) throws IOException {
        this.writeVarUInt(length);
        this.writeRawBytes(data, offset, length);
    }

    public void writeAllBytes(ByteBuffer var1) throws IOException;

    default public void writeBytes(ByteBuffer value, int length) throws IOException {
        this.writeVarUInt(length);
        this.writeRawBytes(value, length);
    }

    public void writeRawBytes(byte[] var1) throws IOException;

    public void writeRawBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeRawBytes(ByteBuffer var1, int var2) throws IOException;

    default public void writeBoolArray(boolean[] data) throws IOException {
        Serializer.BOOLARRAY.serialize(this, data);
    }

    default public void writeByteArray(byte[] data) throws IOException {
        this.writeBytes(data);
    }

    default public void writeUByteArray(byte[] data) throws IOException {
        this.writeBytes(data);
    }

    default public void writeShortArray(short[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (short element : data) {
            this.writeShort(element);
        }
    }

    default public void writeShortArrayRaw(short[] data) throws IOException {
        for (short element : data) {
            this.writeShort(element);
        }
    }

    default public void writeUShortArray(short[] data) throws IOException {
        this.writeShortArray(data);
    }

    default public void writeUShortArrayRaw(short[] data) throws IOException {
        this.writeShortArrayRaw(data);
    }

    default public void writeVarIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeVarInt(element);
        }
    }

    default public void writeVarIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeVarInt(element);
        }
    }

    default public void writeVarUIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeVarUInt(element);
        }
    }

    default public void writeVarUIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeVarUInt(element);
        }
    }

    default public void writeIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeInt(element);
        }
    }

    default public void writeIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeInt(element);
        }
    }

    default public void writeUIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeUInt(element);
        }
    }

    default public void writeUIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeUInt(element);
        }
    }

    default public void writeVarLongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeVarLong(element);
        }
    }

    default public void writeVarLongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeVarLong(element);
        }
    }

    default public void writeVarULongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeVarULong(element);
        }
    }

    default public void writeVarULongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeVarULong(element);
        }
    }

    default public void writeLongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeLong(element);
        }
    }

    default public void writeLongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeLong(element);
        }
    }

    default public void writeULongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeULong(element);
        }
    }

    default public void writeULongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeULong(element);
        }
    }

    default public void writeFloatArray(float[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (float element : data) {
            this.writeFloat(element);
        }
    }

    default public void writeFloatArrayRaw(float[] data) throws IOException {
        for (float element : data) {
            this.writeFloat(element);
        }
    }

    default public void writeDoubleArray(double[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (double element : data) {
            this.writeDouble(element);
        }
    }

    default public void writeDoubleArrayRaw(double[] data) throws IOException {
        for (double element : data) {
            this.writeDouble(element);
        }
    }

    default public void writeStringArray(String[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (String element : data) {
            this.writeString(element);
        }
    }

    default public void writeStringArrayRaw(String[] data) throws IOException {
        for (String element : data) {
            this.writeString(element);
        }
    }

    default public void writeString(String str) throws IOException {
        this.writeBytes(str.getBytes(Charsets.UTF_8));
    }

    default public void writeDate(LocalDate value) throws IOException {
        if (value == null) {
            this.writeVarInt(-32);
            return;
        }
        int ivalue = value.getYear() - 2000;
        ivalue = ivalue * 12 * 31 + (value.getMonthValue() - 1) * 31 + value.getDayOfMonth() - 1;
        this.writeVarInt(ivalue);
    }

    public void flush() throws IOException;
}

