/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.openzen.zengarden.io.DataOutput;

public class StreamingDataOutput
implements DataOutput {
    private static final int P6 = 64;
    private static final int P7 = 128;
    private static final int P13 = 8192;
    private static final int P14 = 16384;
    private static final int P20 = 0x100000;
    private static final int P21 = 0x200000;
    private static final int P27 = 0x8000000;
    private static final int P28 = 0x10000000;
    private static final long P34 = 0x400000000L;
    private static final long P35 = 0x800000000L;
    private static final long P41 = 0x20000000000L;
    private static final long P42 = 0x40000000000L;
    private static final long P48 = 0x1000000000000L;
    private static final long P49 = 0x2000000000000L;
    private static final long P55 = 0x80000000000000L;
    private static final long P56 = 0x100000000000000L;
    private OutputStream output;

    public StreamingDataOutput(OutputStream output) {
        this.output = output;
    }

    @Override
    public void writeSByte(byte value) throws IOException {
        this.output.write(value);
    }

    @Override
    public void writeUByte(int value) throws IOException {
        this.writeSByte((byte)value);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.output.write(value >>> 8);
        this.output.write(value);
    }

    @Override
    public void writeUShort(int value) throws IOException {
        this.writeShort((short)value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.output.write(value >>> 24);
        this.output.write(value >>> 16);
        this.output.write(value >>> 8);
        this.output.write(value);
    }

    @Override
    public void writeUInt(int value) throws IOException {
        this.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.output.write((byte)(value >>> 56));
        this.output.write((byte)(value >>> 48));
        this.output.write((byte)(value >>> 40));
        this.output.write((byte)(value >>> 32));
        this.output.write((byte)(value >>> 24));
        this.output.write((byte)(value >>> 16));
        this.output.write((byte)(value >>> 8));
        this.output.write((byte)value);
    }

    @Override
    public void writeULong(long value) throws IOException {
        this.writeLong(value);
    }

    @Override
    public void writeVarInt(int value) throws IOException {
        if (value >= -64 && value < 64) {
            this.output.write((byte)((value += 64) & 0x7F));
        } else if (value >= -8192 && value < 8192) {
            this.output.write((byte)((value += 8192) & 0x7F | 0x80));
            this.output.write((byte)(value >> 7 & 0x7F));
        } else if (value >= -1048576 && value < 0x100000) {
            this.output.write((byte)((value += 0x100000) & 0x7F | 0x80));
            this.output.write((byte)(value >> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >> 14 & 0x7F));
        } else if (value >= -134217728 && value < 0x8000000) {
            this.output.write((byte)((value += 0x8000000) & 0x7F | 0x80));
            this.output.write((byte)(value >> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >> 14 & 0x7F | 0x80));
            this.output.write((byte)(value >> 21 & 0x7F));
        } else {
            this.output.write((byte)(value & 0x7F | 0x80));
            this.output.write((byte)(value >>> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 14 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 21 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 28 & 0x7F));
        }
    }

    @Override
    public void writeVarUInt(int value) throws IOException {
        if (value >= 0 && value < 0x10000000) {
            if (value < 128) {
                this.output.write((byte)(value & 0x7F));
            } else if (value < 16384) {
                this.output.write((byte)(value & 0x7F | 0x80));
                this.output.write((byte)(value >> 7 & 0x7F));
            } else if (value < 0x200000) {
                this.output.write((byte)(value & 0x7F | 0x80));
                this.output.write((byte)(value >> 7 & 0x7F | 0x80));
                this.output.write((byte)(value >> 14 & 0x7F));
            } else {
                this.output.write((byte)(value & 0x7F | 0x80));
                this.output.write((byte)(value >> 7 & 0x7F | 0x80));
                this.output.write((byte)(value >> 14 & 0x7F | 0x80));
                this.output.write((byte)(value >> 21 & 0x7F));
            }
        } else {
            this.output.write((byte)(value & 0x7F | 0x80));
            this.output.write((byte)(value >>> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 14 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 21 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 28 & 0x7F));
        }
    }

    @Override
    public void writeVarLong(long value) throws IOException {
        if (value >= -64L && value < 64L) {
            this.output.write((byte)((value += 64L) & 0x7FL));
        } else if (value >= -8192L && value < 8192L) {
            this.output.write((byte)((value += 8192L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL));
        } else if (value >= -1048576L && value < 0x100000L) {
            this.output.write((byte)((value += 0x100000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL));
        } else if (value >= -134217728L && value < 0x8000000L) {
            this.output.write((byte)((value += 0x8000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL));
        } else if (value >= -17179869184L && value < 0x400000000L) {
            this.output.write((byte)((value += 0x400000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL));
        } else if (value >= -2199023255552L && value < 0x40000000000L) {
            this.output.write((byte)((value += 0x20000000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 35 & 0x7FL));
        } else if (value >= -281474976710656L && value < 0x1000000000000L) {
            this.output.write((byte)((value += 0x1000000000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 42 & 0x7FL));
        } else if (value >= -36028797018963968L && value < 0x80000000000000L) {
            this.output.write((byte)((value += 0x80000000000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 42 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 49 & 0x7FL));
        } else {
            this.output.write((byte)(value & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 42 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 49 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 56));
        }
    }

    @Override
    public void writeVarULong(long value) throws IOException {
        if (value >= 0L && value < 0x100000000000000L) {
            if (value < 128L) {
                this.output.write((byte)(value & 0x7FL));
            } else if (value < 16384L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL));
            } else if (value < 0x200000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL));
            } else if (value < 0x10000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL));
            } else if (value < 0x800000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL));
            } else if (value < 0x40000000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 35 & 0x7FL));
            } else if (value < 0x2000000000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 42 & 0x7FL));
            } else {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 42 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 49 & 0x7FL));
            }
        } else {
            this.output.write((byte)(value & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 42 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 49 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 56));
        }
    }

    @Override
    public void writeRawBytes(byte[] value) throws IOException {
        this.output.write(value);
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.output.write(value, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    @Override
    public void writeAllBytes(ByteBuffer value) throws IOException {
        value.rewind();
        byte[] tmp = new byte[value.capacity()];
        value.get(tmp);
        this.writeBytes(tmp);
    }

    @Override
    public void writeRawBytes(ByteBuffer value, int length) throws IOException {
        byte[] tmp = new byte[length];
        value.get(tmp, 0, length);
        this.writeRawBytes(tmp);
    }
}

