/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.lexer;

import gnu.trove.map.hash.TIntIntHashMap;

public class CompiledDFA<T> {
    public static final int NOFINAL = Integer.MIN_VALUE;
    public TIntIntHashMap[] transitions;
    public T[] finals;

    public CompiledDFA(TIntIntHashMap[] transitions, T[] finals) {
        this.transitions = transitions;
        this.finals = finals;
    }

    public T eval(String value) {
        int state = 0;
        for (char c : value.toCharArray()) {
            if ((state = this.transitions[state].get((int)c)) != Integer.MIN_VALUE) continue;
            return null;
        }
        return this.finals[state];
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        for (i = 0; i < this.transitions.length; ++i) {
            TIntIntHashMap map = this.transitions[i];
            for (int v : map.keySet()) {
                result.append("edge(");
                result.append(i);
                result.append(", ");
                result.append(v);
                result.append("): ");
                result.append(map.get(v));
                result.append("\r\n");
            }
        }
        for (i = 0; i < this.finals.length; ++i) {
            if (this.finals[i] == null) continue;
            result.append("final(");
            result.append(i);
            result.append("): ");
            result.append(this.finals[i]);
            result.append("\r\n");
        }
        return result.toString();
    }
}

