/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.function.Function;
import org.openzen.zengarden.events.ListenerHandle;
import org.openzen.zengarden.events.ListenerList;
import org.openzen.zengarden.index.AutoIndex;
import org.openzen.zengarden.watched.WatchedIndex;
import org.openzen.zengarden.watched.WatchedIndexListener;

public class WatchedAutoIndex<K, V>
extends AutoIndex<K, V>
implements WatchedIndex<K, V> {
    private ListenerList<WatchedIndexListener<K, V>> listeners;

    public WatchedAutoIndex(Function<V, K> indexer) {
        super(indexer);
    }

    @Override
    public boolean add(V value) {
        boolean result = super.add(value);
        if (result) {
            Object key = this.getKey(value);
            this.listeners.accept(listener -> listener.onAdded(key, value));
        }
        return result;
    }

    @Override
    public boolean remove(V value) {
        boolean result = super.remove(value);
        if (result) {
            Object key = this.getKey(value);
            this.listeners.accept(listener -> listener.onRemoved(key, value));
        }
        return result;
    }

    @Override
    public ListenerHandle<WatchedIndexListener<K, V>> addListener(WatchedIndexListener<K, V> listener) {
        return this.listeners.add(listener);
    }
}

