/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.property.StringProperty;
import org.openzen.zengarden.diff.StringDiff;
import org.openzen.zengarden.watched.WatchedValue;

public interface WatchedString
extends WatchedValue<String> {
    public String get();

    public void set(String var1);

    default public StringDiff getUpdates() {
        return StringDiff.create(this.get());
    }

    default public void apply(StringDiff updates) {
        this.set(updates.update(this.get()));
    }

    default public void bind(StringProperty property) {
        this.whenChanged(value -> {
            if (!Objects.equals(property.get(), value.newValue)) {
                property.set(value.newValue);
            }
        });
        property.addListener((observable, oldValue, newValue) -> {
            if (!Objects.equals(this.get(), newValue)) {
                this.set((String)newValue);
            }
        });
    }

    default public void bindTo(StringProperty property) {
        this.whenChanged(value -> {
            if (!Objects.equals(property.get(), value.newValue)) {
                property.set(value.newValue);
            }
        });
    }

    public WatchedString lock();

    public WatchedString guard(Predicate<String> var1);
}

