/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.events;

import java.util.function.Consumer;
import org.openzen.zengarden.events.EventListener;
import org.openzen.zengarden.events.ListenerHandle;

public class ListenerList<T> {
    public static final int PRIORITY_HIGH = 100;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_LOW = -100;
    protected volatile EventListenerNode first = null;
    protected EventListenerNode last = null;

    public ListenerHandle<T> add(T listener) {
        return this.add(listener, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerHandle<T> add(T listener, int priority) {
        EventListenerNode node = new EventListenerNode(listener, priority);
        ListenerList listenerList = this;
        synchronized (listenerList) {
            if (this.first == null) {
                this.first = this.last = node;
            } else {
                EventListenerNode previousNode = this.last;
                while (previousNode != null && priority > previousNode.priority) {
                    previousNode = previousNode.prev;
                }
                if (previousNode == null) {
                    node.next = this.first;
                    this.first.prev = previousNode;
                    this.first = node;
                } else {
                    if (previousNode.next == null) {
                        this.last = node;
                    } else {
                        previousNode.next.prev = node;
                    }
                    previousNode.next = node;
                    node.prev = previousNode;
                }
            }
        }
        return node;
    }

    public synchronized boolean remove(EventListener<T> listener) {
        EventListenerNode current = this.first;
        while (current != null) {
            if (current.listener.equals(listener)) {
                current.close();
                return true;
            }
            current = current.next;
        }
        return false;
    }

    public synchronized void clear() {
        this.last = null;
        this.first = null;
    }

    public void accept(Consumer<T> consumer) {
        EventListenerNode current = this.first;
        while (current != null) {
            consumer.accept(current.listener);
            current = current.next;
        }
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    protected class EventListenerNode
    implements ListenerHandle<T> {
        protected final T listener;
        protected final int priority;
        protected EventListenerNode next = null;
        protected EventListenerNode prev = null;

        public EventListenerNode(T handler, int priority) {
            this.listener = handler;
            this.priority = priority;
        }

        @Override
        public T getListener() {
            return this.listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ListenerList listenerList = ListenerList.this;
            synchronized (listenerList) {
                if (this.prev == null) {
                    ListenerList.this.first = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next == null) {
                    ListenerList.this.last = this.prev;
                } else {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

