/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.function.LongPredicate;
import org.openzen.zengarden.watched.AbstractWatchedValue;
import org.openzen.zengarden.watched.GuardedLong;
import org.openzen.zengarden.watched.LockedLong;
import org.openzen.zengarden.watched.WatchedLong;

public class BasicWatchedLong
extends AbstractWatchedValue<Long>
implements WatchedLong {
    private volatile long value;

    public BasicWatchedLong(long initialValue) {
        this.value = initialValue;
    }

    @Override
    public long get() {
        return this.value;
    }

    @Override
    public void set(long value) {
        long oldValue = this.value;
        if (!this.onBeforeChange(oldValue, value)) {
            this.value = value;
            this.onChanged(oldValue, this.value);
        }
    }

    public void or(long value) {
        this.set(this.value | value);
    }

    public void and(long value) {
        this.set(this.value & value);
    }

    @Override
    public WatchedLong lock() {
        return new LockedLong(this);
    }

    @Override
    public WatchedLong guard(LongPredicate test) {
        return new GuardedLong(this, test);
    }
}

