/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Predicate;
import org.openzen.zengarden.function.Function;
import org.openzen.zengarden.util.ZObjects;

public class ZArrays {
    private ZArrays() {
    }

    public static <T> int indexOf(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            if (!ZObjects.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!ZObjects.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T, R> R[] map(Class<R> component, T[] array, Function<T, R> function) {
        Object[] newArray = (Object[])Array.newInstance(component, array.length);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = function.apply(array[i]);
        }
        return newArray;
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate) {
        T[] newArray = Arrays.copyOf(array, array.length);
        int results = 0;
        for (T value : array) {
            if (!predicate.test(value)) continue;
            newArray[results++] = value;
        }
        return Arrays.copyOf(newArray, results);
    }
}

