/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.lang.reflect.Array;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openzen.zengarden.collections.ZArrayList;
import org.openzen.zengarden.collections.ZMappedCollection;

public interface ZCollection<T>
extends Iterable<T> {
    public Class<T> getElementClass();

    public boolean add(T var1);

    public boolean remove(T var1);

    public boolean contains(T var1);

    default public boolean addAll(Iterable<? extends T> c) {
        boolean changed = false;
        for (T value : c) {
            changed = true;
            this.add(value);
        }
        return changed;
    }

    default public boolean removeAll(Iterable<? extends T> c) {
        boolean changed = false;
        for (T value : c) {
            changed |= this.remove(value);
        }
        return changed;
    }

    default public boolean containsAll(Iterable<? extends T> c) {
        for (T value : c) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public int size();

    public void clear();

    default public boolean isEmpty() {
        return this.size() > 0;
    }

    default public T[] toArray() {
        Object[] array = (Object[])Array.newInstance(this.getElementClass(), this.size());
        int i = 0;
        for (Object value : this) {
            array[i++] = value;
        }
        return array;
    }

    default public <U> ZCollection<U> mapLive(Class<U> type, Function<T, U> converter) {
        return new ZMappedCollection<T, U>(type, this, converter);
    }

    default public <U> ZCollection<U> mapLive(Class<U> type, Function<T, U> converter, Function<U, T> backwardsConverter) {
        return new ZMappedCollection<T, U>(type, this, converter, backwardsConverter);
    }

    default public <U> ZCollection<U> map(Class<U> type, Function<T, U> converter) {
        ZArrayList<U> result = new ZArrayList<U>(type);
        for (Object value : this) {
            result.add(converter.apply(value));
        }
        return result;
    }

    default public ZCollection<T> filter(Predicate<T> predicate) {
        ZArrayList result = new ZArrayList(this.getElementClass());
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            result.add(value);
        }
        return result;
    }

    default public <U> U reduce(BiFunction<U, T, U> reductor, U initialValue) {
        U result = initialValue;
        for (Object value : this) {
            result = reductor.apply(result, value);
        }
        return result;
    }
}

