/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.promise;

import java.util.function.Consumer;
import org.openzen.zengarden.promise.Promise;

public class ResolvedPromise<R, S, E extends Throwable>
implements Promise<R, S, E> {
    private final R response;
    private final Class<E> errorClass;
    private final Consumer<Runnable> runner;

    public ResolvedPromise(R response, Class<E> errorClass) {
        this(response, errorClass, runnable -> runnable.run());
    }

    public ResolvedPromise(R response, Class<E> errorClass, Consumer<Runnable> runner) {
        this.response = response;
        this.errorClass = errorClass;
        this.runner = runner;
    }

    @Override
    public Class<E> getErrorClass() {
        return this.errorClass;
    }

    @Override
    public Promise<R, S, E> onDone(Consumer<R> consumer) {
        this.runner.accept(() -> consumer.accept(this.response));
        return this;
    }

    @Override
    public Promise<R, S, E> onCached(Consumer<R> consumer) {
        return this;
    }

    @Override
    public Promise<R, S, E> onStatus(Consumer<S> consumer) {
        return this;
    }

    @Override
    public Promise<R, S, E> onFail(Consumer<E> consumer) {
        return this;
    }

    @Override
    public R get() throws E {
        return this.response;
    }
}

