/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.security;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.mindrot.jbcrypt.BCrypt;
import org.openzen.zengarden.arrays.ByteArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.security.ZDecryptor;
import org.openzen.zengarden.security.ZEncryptor;
import org.openzen.zengarden.security.ZKeyPair;
import org.openzen.zengarden.security.ZPrivateKey;
import org.openzen.zengarden.security.ZPublicKey;
import org.openzen.zengarden.security.ZSymmetricKey;

public final class ZCoder {
    private static final ThreadLocal<ZCoder> CODERS = new ThreadLocal<ZCoder>(){

        @Override
        protected ZCoder initialValue() {
            return new ZCoder();
        }
    };
    private static final int TYPE_PUBLIC_P256 = 1;
    private static final int TYPE_PRIVATE_P256 = 2;
    private static final int TYPE_SYMMETRIC_AES128 = 3;
    private final SecureRandom random = new SecureRandom();
    private final ECNamedCurveParameterSpec p256CurveSpec = ZCoder.getNISTCurveSpec("P-256");
    private final KeyPairGenerator keyPairGenerator;

    public static ZCoder getInstance() {
        return CODERS.get();
    }

    private ZCoder() {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("ECDH", "BC");
            keyPairGen.initialize((AlgorithmParameterSpec)this.p256CurveSpec, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            Logger.getLogger(ZCoder.class.getName()).log(Level.SEVERE, "Could not initialize OpenZenCoder", ex);
        }
        this.keyPairGenerator = keyPairGen;
    }

    public ZKeyPair generateKeyPair() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
        return new ZKeyPair(new OZCPrivateKey(ecPrivateKey), new OZCPublicKey(ecPublicKey));
    }

    public ZSymmetricKey generateKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            SecretKey secretKey = keyGen.generateKey();
            return new OZCSymmetricKey(secretKey);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public ZPrivateKey decodePrivateKey(byte[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Empty key data");
        }
        BytesDataInput input = new BytesDataInput(data);
        if (input.readVarUInt() != 2) {
            throw new IllegalArgumentException("Not a private key");
        }
        BigInteger d = new BigInteger(input.readBytes());
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(d, (ECParameterSpec)this.p256CurveSpec);
        BCECPrivateKey privateKey = new BCECPrivateKey("EC", privateKeySpec, BouncyCastleProvider.CONFIGURATION);
        return new OZCPrivateKey((ECPrivateKey)privateKey);
    }

    public ZPublicKey decodePublicKey(byte[] data) {
        if (data.length < 2) {
            throw new IllegalArgumentException("Empty key data");
        }
        BytesDataInput input = new BytesDataInput(data);
        if (input.readVarUInt() != 1) {
            throw new IllegalArgumentException("Not a public key");
        }
        BigInteger x = new BigInteger(input.readBytes());
        BigInteger y = new BigInteger(input.readBytes());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(this.p256CurveSpec.getCurve().createPoint(x, y), (ECParameterSpec)this.p256CurveSpec);
        BCECPublicKey publicKey = new BCECPublicKey("EC", publicKeySpec, BouncyCastleProvider.CONFIGURATION);
        return new OZCPublicKey((ECPublicKey)publicKey);
    }

    public ZSymmetricKey decodeSymmetricKey(byte[] data) {
        if (data.length < 2) {
            throw new IllegalArgumentException("Empty key data");
        }
        BytesDataInput input = new BytesDataInput(data);
        if (input.readVarUInt() != 3) {
            throw new IllegalArgumentException("Not a symmetric key");
        }
        return new OZCSymmetricKey(input.readBytes());
    }

    public byte[] sha256(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError("Could not calculate hash", ex);
        }
    }

    public byte[] sha512(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError("Could not calculate hash", ex);
        }
    }

    public String bcryptHash(String data) {
        return this.bcryptHash(data, 10);
    }

    public String bcryptHash(String data, int workFactor) {
        return BCrypt.hashpw((String)data, (String)BCrypt.gensalt((int)workFactor));
    }

    public boolean bcryptCheck(String hash, String data) {
        return BCrypt.checkpw((String)data, (String)hash);
    }

    private static ECNamedCurveParameterSpec getNISTCurveSpec(String name) {
        X9ECParameters parameters = NISTNamedCurves.getByName((String)name);
        return new ECNamedCurveParameterSpec(name, parameters.getCurve(), parameters.getG(), parameters.getN(), parameters.getH(), parameters.getSeed());
    }

    private static boolean hasBouncyCastleProvider() {
        for (Provider provider : Security.getProviders()) {
            if (!(provider instanceof BouncyCastleProvider)) continue;
            return true;
        }
        return false;
    }

    private static void removeCryptographyRestrictions() {
        if (!ZCoder.isRestrictedCryptography()) {
            return;
        }
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
            isRestrictedField.setAccessible(true);
            isRestrictedField.set(null, false);
            Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
            defaultPolicyField.setAccessible(true);
            PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
            Field perms = cryptoPermissions.getDeclaredField("perms");
            perms.setAccessible(true);
            ((Map)perms.get(defaultPolicy)).clear();
            Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
            instance.setAccessible(true);
            defaultPolicy.add((Permission)instance.get(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isRestrictedCryptography() {
        return "Java(TM) SE Runtime Environment".equals(System.getProperty("java.runtime.name"));
    }

    static {
        ZCoder.removeCryptographyRestrictions();
        if (!ZCoder.hasBouncyCastleProvider()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private static class OZCCoder {
        private Cipher cipher;

        public OZCCoder(Key key, int mode) throws GeneralSecurityException {
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            byte[] iv = key.getEncoded();
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            this.cipher.init(mode, key, ivSpec);
        }

        public byte[] code(byte[] data) throws GeneralSecurityException {
            return this.cipher.doFinal(data);
        }
    }

    private static final class OZCDecoder
    extends OZCCoder
    implements ZDecryptor {
        public OZCDecoder(Key key) throws GeneralSecurityException {
            super(key, 2);
        }

        @Override
        public byte[] decrypt(byte[] data) throws GeneralSecurityException {
            return this.code(data);
        }
    }

    private static final class OZCEncoder
    extends OZCCoder
    implements ZEncryptor {
        public OZCEncoder(Key key) throws GeneralSecurityException {
            super(key, 1);
        }

        @Override
        public byte[] encrypt(byte[] data) throws GeneralSecurityException {
            return this.code(data);
        }
    }

    private static final class OZCSymmetricKey
    implements ZSymmetricKey {
        private final Key key;

        public OZCSymmetricKey(byte[] key) {
            this.key = new SecretKeySpec(key, "AES-128");
        }

        public OZCSymmetricKey(Key key) {
            this.key = key;
        }

        @Override
        public byte[] encode() {
            return ByteArrayFunctions.INSTANCE.concat(new byte[]{3}, this.key.getEncoded());
        }

        @Override
        public ZEncryptor createEncryptor() {
            try {
                return new OZCEncoder(this.key);
            }
            catch (GeneralSecurityException exception) {
                throw new AssertionError((Object)exception);
            }
        }

        @Override
        public ZDecryptor createDecryptor() {
            try {
                return new OZCDecoder(this.key);
            }
            catch (GeneralSecurityException exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    private static final class OZCPublicKey
    implements ZPublicKey {
        private final ECPublicKey publicKey;

        public OZCPublicKey(ECPublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public byte[] encode() {
            ECPoint q = this.publicKey.getW();
            byte[] xBytes = q.getAffineX().toByteArray();
            byte[] yBytes = q.getAffineY().toByteArray();
            BytesDataOutput output = new BytesDataOutput();
            output.writeVarUInt(1);
            output.writeBytes(xBytes);
            output.writeBytes(yBytes);
            return output.toByteArray();
        }

        @Override
        public byte[] encrypt(byte[] data) {
            try {
                Cipher cipher = Cipher.getInstance("ECIES", "BC");
                byte[] iv = this.encode();
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(1, (Key)this.publicKey, ivSpec);
                return cipher.doFinal(data);
            }
            catch (GeneralSecurityException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        public boolean verifySignature(byte[] data, byte[] signature) {
            try {
                Signature ecdsaVerify = Signature.getInstance("SHA256withECDSA", "BC");
                ecdsaVerify.initVerify(this.publicKey);
                ecdsaVerify.update(data);
                return ecdsaVerify.verify(signature);
            }
            catch (GeneralSecurityException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    private static final class OZCPrivateKey
    implements ZPrivateKey {
        private final ECPrivateKey privateKey;

        public OZCPrivateKey(ECPrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public byte[] encode() {
            BytesDataOutput output = new BytesDataOutput();
            output.writeVarUInt(2);
            output.writeBytes(this.privateKey.getD().toByteArray());
            return output.toByteArray();
        }

        @Override
        public ZSymmetricKey makeKey(ZPublicKey otherPartyPublicKey) {
            OZCPublicKey publicKey = (OZCPublicKey)otherPartyPublicKey;
            try {
                KeyAgreement keyAgree = KeyAgreement.getInstance("ECDH", "BC");
                keyAgree.init((Key)this.privateKey);
                keyAgree.doPhase(publicKey.publicKey, true);
                SecretKey key = keyAgree.generateSecret(NISTObjectIdentifiers.id_aes128_CBC.getId());
                return new OZCSymmetricKey(key);
            }
            catch (GeneralSecurityException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        public byte[] decrypt(byte[] data) {
            try {
                Cipher cipher = Cipher.getInstance("ECIES", "BC");
                byte[] iv = this.encode();
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(2, (Key)this.privateKey, ivSpec);
                return cipher.doFinal(data);
            }
            catch (GeneralSecurityException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        public byte[] sign(byte[] data) {
            try {
                Signature ecdsaSign = Signature.getInstance("SHA256withECDSA", "BC");
                ecdsaSign.initSign((PrivateKey)this.privateKey);
                ecdsaSign.update(data);
                return ecdsaSign.sign();
            }
            catch (GeneralSecurityException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

