/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.diff;

import java.io.IOException;
import java.util.Stack;
import java.util.TreeMap;
import org.openzen.zengarden.diff.DataDiff;
import org.openzen.zengarden.diff.StringUpdater;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;
import org.openzen.zengarden.util.Charsets;
import org.openzen.zengarden.util.Strings;

public class StringDiff
implements DataDiff<String> {
    private static final int CHOICE_COPY = 1;
    private static final int CHOICE_SKIP = 2;
    private static final int CHOICE_INSERT = 3;
    private static final int DONT = 2147483547;
    private final byte[] data;

    public static StringDiff create(String value) {
        return StringDiff.getBuilder().insert(value).end();
    }

    public static StringDiff diff(String original, String modified) {
        if (original.equals(modified)) {
            return StringDiff.getBuilder().copyTilEnd();
        }
        if (modified.startsWith(original)) {
            return StringDiff.getBuilder().copy(original.length()).insert(modified.substring(original.length())).end();
        }
        if (original.startsWith(modified)) {
            return StringDiff.getBuilder().copy(modified.length()).end();
        }
        int commonPrefix = Strings.getCommonPrefixLength(original, modified);
        int commonSuffix = Strings.getCommonSuffixLength(original, modified);
        if ((original.length() - commonPrefix - commonSuffix) * (modified.length() - commonPrefix - commonSuffix) < 10000000) {
            return StringDiff.diffExact(original, modified, commonPrefix, commonSuffix);
        }
        return StringDiff.diffApproximate(original, modified, commonPrefix, commonSuffix);
    }

    public static StringDiff read(DataInput input) throws IOException {
        return StringDiff.decode(input, StringDiff.getBuilder());
    }

    private static StringDiff diffExact(String original, String modified, int commonHead, int commonTail) {
        int i;
        int originalCompareLength = original.length() - commonHead - commonTail;
        int modifiedCompareLength = modified.length() - commonHead - commonTail;
        int length = (originalCompareLength + 1) * (modifiedCompareLength + 1);
        int[] costsCopy = new int[length];
        int[] costsSkip = new int[length];
        int[] costsInsert = new int[length];
        int width = originalCompareLength + 1;
        costsCopy[0] = 0;
        costsSkip[0] = 0;
        costsInsert[0] = 0;
        for (i = 0; i < originalCompareLength; ++i) {
            costsCopy[i + 1] = 2147483547;
            costsSkip[i + 1] = 1;
            costsInsert[i + 1] = 2147483547;
        }
        for (i = 1; i <= modifiedCompareLength; ++i) {
            costsCopy[width * i] = 2147483547;
            costsSkip[width * i] = 2147483547;
            costsInsert[width * i] = i + 1;
        }
        for (i = 0; i < originalCompareLength; ++i) {
            for (int j = 0; j < modifiedCompareLength; ++j) {
                int offset = i + j * width + 1 + width;
                costsSkip[offset] = Math.min(costsSkip[offset - 1], Math.min(costsCopy[offset - 1], costsInsert[offset - 1]) + 1);
                costsInsert[offset] = Math.min(costsInsert[offset - width] + 1, Math.min(costsCopy[offset - width], costsSkip[offset - width]) + 2);
                costsCopy[offset] = original.charAt(commonHead + i) == modified.charAt(commonHead + j) ? Math.min(costsCopy[offset - 1 - width], Math.min(costsSkip[offset - 1 - width], costsInsert[offset - 1 - width]) + 1) : 2147483547;
            }
        }
        Stack<Integer> choiceStack = new Stack<Integer>();
        int i2 = originalCompareLength;
        int j = modifiedCompareLength;
        while (i2 > 0 || j > 0) {
            int choice;
            int offset = i2 + j * width;
            int lowest = Math.min(costsSkip[offset], Math.min(costsInsert[offset], costsCopy[offset]));
            if (lowest == costsCopy[offset]) {
                --i2;
                --j;
                choice = 1;
            } else if (lowest == costsInsert[offset]) {
                --j;
                choice = 3;
            } else if (lowest == costsSkip[offset]) {
                --i2;
                choice = 2;
            } else {
                throw new AssertionError();
            }
            if (i2 < 0 || j < 0) {
                throw new AssertionError();
            }
            choiceStack.add(choice);
        }
        StringUpdateBuilder builder = StringDiff.getBuilder();
        int currentChoice = -1;
        int currentChoiceLength = 0;
        int modifiedOffset = 0;
        if (commonHead > 0) {
            currentChoice = 1;
            currentChoiceLength = commonHead;
        }
        while (!choiceStack.isEmpty()) {
            int newChoice = (Integer)choiceStack.pop();
            if (newChoice != currentChoice) {
                if (currentChoice == 1) {
                    builder.copy(currentChoiceLength);
                    modifiedOffset += currentChoiceLength;
                } else if (currentChoice == 2) {
                    builder.skip(currentChoiceLength);
                } else if (currentChoice == 3) {
                    String value = modified.substring(modifiedOffset, modifiedOffset + currentChoiceLength);
                    builder.insert(value);
                    modifiedOffset += currentChoiceLength;
                }
                currentChoiceLength = 0;
                currentChoice = newChoice;
            }
            ++currentChoiceLength;
        }
        if (currentChoice == 1) {
            return builder.copyTilEnd();
        }
        if (currentChoice == 2) {
            if (commonTail > 0) {
                builder.skip(currentChoiceLength);
                return builder.copyTilEnd();
            }
            return builder.end();
        }
        if (currentChoice == 3) {
            String value = modified.substring(modifiedOffset, modifiedOffset + currentChoiceLength);
            builder.insert(value);
            if (commonTail > 0) {
                return builder.copyTilEnd();
            }
            return builder.end();
        }
        throw new AssertionError();
    }

    private static StringDiff diffApproximate(String original, String modified, int commonHead, int commonTail) {
        return StringDiff.getBuilder().copy(commonHead).skip(original.length() - commonHead - commonTail).insert(modified.substring(commonHead, modified.length() - commonTail)).copyTilEnd();
    }

    public StringDiff(byte[] data) {
        this.data = data;
    }

    public StringDiff(DataInput input) throws IOException {
        this.data = input.readBytes();
    }

    public <T, R> R decode(StringUpdater<T, R> update) {
        try {
            BytesDataInput input = new BytesDataInput(this.data);
            return StringDiff.decode(input, update);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static <T, R> R decode(DataInput input, StringUpdater<T, R> update) throws IOException {
        while (true) {
            if (!input.hasMore()) {
                return update.end();
            }
            int cmd = input.readVarUInt();
            if ((cmd & 3) == 0) {
                byte[] strBytes = input.readRawBytes(cmd >> 2);
                update.insert(new String(strBytes, Charsets.UTF_8));
                continue;
            }
            if ((cmd & 3) == 1) {
                int length = cmd >> 2;
                if (length == 0) {
                    return update.copyTilEnd();
                }
                update.copy(length);
                continue;
            }
            if ((cmd & 3) != 2) break;
            update.skip(cmd >> 2);
        }
        return update.end();
    }

    public StringDiff shift(StringDiff other) {
        ShiftCalculator shiftCalculator = new ShiftCalculator();
        Shifter shifter = new Shifter(this.decode(shiftCalculator));
        return this.decode(shifter);
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        output.writeRawBytes(this.data);
    }

    public int length() {
        return this.data.length;
    }

    @Override
    public String update(String original) {
        Applier applier = new Applier(original);
        return this.decode(applier);
    }

    public static StringUpdateBuilder getBuilder() {
        return new StringUpdateBuilder();
    }

    public String toString() {
        Printer printer = new Printer();
        return this.decode(printer);
    }

    private static class Shifter
    implements StringUpdater<Void, StringDiff> {
        private final TreeMap<Integer, Integer> positions;
        private final StringUpdateBuilder builder = StringDiff.getBuilder();
        private int inputPosition = 0;

        private Shifter(TreeMap<Integer, Integer> positions) {
            this.positions = positions;
        }

        private int shift(int position) {
            int floor = this.positions.floorKey(position);
            return this.positions.get(floor) + (position - floor);
        }

        @Override
        public Void copy(int length) {
            int toPosition;
            int fromPosition = this.shift(this.inputPosition);
            this.inputPosition = toPosition = this.shift(this.inputPosition + length);
            this.builder.copy(toPosition - fromPosition);
            return null;
        }

        @Override
        public Void skip(int offset) {
            int toPosition;
            int fromPosition = this.shift(this.inputPosition);
            this.inputPosition = toPosition = this.shift(this.inputPosition + offset);
            this.builder.skip(toPosition - fromPosition);
            return null;
        }

        @Override
        public Void insert(String value) {
            this.builder.insert(value);
            return null;
        }

        @Override
        public StringDiff copyTilEnd() {
            return this.builder.copyTilEnd();
        }

        @Override
        public StringDiff end() {
            return this.builder.end();
        }
    }

    private static class ShiftCalculator
    implements StringUpdater<Void, TreeMap<Integer, Integer>> {
        private final TreeMap<Integer, Integer> positions = new TreeMap();
        private int inputPointer = 0;
        private int outputPointer = 0;

        private ShiftCalculator() {
        }

        @Override
        public Void copy(int length) {
            this.mark();
            this.inputPointer += length;
            this.outputPointer += length;
            return null;
        }

        @Override
        public Void skip(int offset) {
            this.inputPointer += offset;
            return null;
        }

        @Override
        public Void insert(String value) {
            this.mark();
            this.outputPointer += value.length();
            return null;
        }

        @Override
        public TreeMap<Integer, Integer> copyTilEnd() {
            this.mark();
            return this.positions;
        }

        @Override
        public TreeMap<Integer, Integer> end() {
            this.mark();
            return this.positions;
        }

        private void mark() {
            this.positions.put(this.inputPointer, this.outputPointer);
        }
    }

    private static class Applier
    implements StringUpdater<Void, String> {
        private int pointer = 0;
        private final String original;
        private final StringBuilder builder = new StringBuilder();

        public Applier(String original) {
            this.original = original;
        }

        @Override
        public Void copy(int length) {
            this.builder.append(this.original.substring(this.pointer, this.pointer + length));
            this.pointer += length;
            return null;
        }

        @Override
        public Void skip(int offset) {
            this.pointer += offset;
            return null;
        }

        @Override
        public Void insert(String value) {
            this.builder.append(value);
            return null;
        }

        @Override
        public String copyTilEnd() {
            this.builder.append(this.original.substring(this.pointer));
            return this.builder.toString();
        }

        @Override
        public String end() {
            return this.builder.toString();
        }
    }

    private static class Printer
    implements StringUpdater<Void, String> {
        public final StringBuilder builder = new StringBuilder();

        private Printer() {
        }

        @Override
        public Void copy(int length) {
            this.builder.append(" Copy(").append(length).append(")");
            return null;
        }

        @Override
        public Void skip(int offset) {
            this.builder.append(" Skip(").append(offset).append(")");
            return null;
        }

        @Override
        public Void insert(String value) {
            if (value.length() > 100) {
                this.builder.append(" Insert(").append(value).append(" chars)");
            } else {
                this.builder.append(" Insert(").append(value).append(")");
            }
            return null;
        }

        @Override
        public String copyTilEnd() {
            this.builder.append(" CopyTilEnd");
            return this.builder.toString();
        }

        @Override
        public String end() {
            this.builder.append(" End");
            return this.builder.toString();
        }
    }

    public static class StringUpdateBuilder
    implements StringUpdater<StringUpdateBuilder, StringDiff> {
        private BytesDataOutput output = new BytesDataOutput();

        private StringUpdateBuilder() {
        }

        @Override
        public StringUpdateBuilder insert(String value) {
            if (value.isEmpty()) {
                return this;
            }
            byte[] strBytes = value.getBytes(Charsets.UTF_8);
            this.output.writeVarUInt(strBytes.length << 2);
            this.output.writeRawBytes(strBytes);
            return this;
        }

        @Override
        public StringUpdateBuilder copy(int length) {
            if (length == 0) {
                return this;
            }
            this.output.writeVarUInt(length << 2 | 1);
            return this;
        }

        @Override
        public StringUpdateBuilder skip(int bytes) {
            if (bytes == 0) {
                return this;
            }
            this.output.writeVarUInt(bytes << 2 | 2);
            return this;
        }

        public StringUpdateBuilder copyFrom(int position, int bytes) {
            if (bytes == 0) {
                return this;
            }
            this.output.writeVarUInt(2);
            this.output.writeVarUInt(position);
            this.output.writeVarUInt(bytes);
            return this;
        }

        @Override
        public StringDiff copyTilEnd() {
            this.output.writeVarUInt(1);
            return this.build();
        }

        @Override
        public StringDiff end() {
            this.output.writeVarUInt(3);
            return this.build();
        }

        private StringDiff build() {
            return new StringDiff(this.output.toByteArray());
        }
    }
}

