/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class FlexDateTime {
    private static final int SHIFT_YEAR = 41;
    private static final int SHIFT_MONTH = 36;
    private static final int SHIFT_DAY = 31;
    private static final int SHIFT_HOUR = 26;
    private static final int SHIFT_MINUTES = 21;
    private static final int SHIFT_SECONDS = 16;
    private static final int SHIFT_MILLISECONDS = 6;
    private static final int MASK_YEAR = 4095;
    private static final int MASK_MONTH = 15;
    private static final int MASK_DAY = 31;
    private static final int MASK_HOURS = 31;
    private static final int MASK_MINUTES = 63;
    private static final int MASK_SECONDS = 63;
    private static final int MASK_MILLISECONDS = 1023;
    private static final int MASK_TIMEZONE = 63;
    public static final int UNKNOWN = -1;
    public static final double UNKNOWN_TIMEZONE = Double.NaN;
    private final long value;

    public FlexDateTime(LocalDateTime dateTimeUTC) {
        this(dateTimeUTC.getYear(), dateTimeUTC.getMonth().getValue(), dateTimeUTC.getDayOfMonth(), dateTimeUTC.getHour(), dateTimeUTC.getMinute(), dateTimeUTC.getSecond(), dateTimeUTC.getNano() / 1000000, ZoneOffset.UTC);
    }

    public FlexDateTime(int year, int month, int day) {
        this(year, month, day, -1, -1, -1, -1, null);
    }

    public FlexDateTime(int year, int month, int day, int hours, int minutes) {
        this(year, month, day, hours, minutes, 0, 0, null);
    }

    public FlexDateTime(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds, ZoneOffset timezone) {
        if (year < -1 || year > 4000) {
            throw new IllegalArgumentException("Invalid year: " + year);
        }
        if (month < -1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (day < -1 || day > 31) {
            throw new IllegalArgumentException("Invalid day: " + day);
        }
        if (hours < -1 || hours > 23) {
            throw new IllegalArgumentException("Invalid hour: " + hours);
        }
        if (minutes < -1 || minutes > 59) {
            throw new IllegalArgumentException("Invalid minute: " + minutes);
        }
        if (seconds < -1 || seconds > 59) {
            throw new IllegalArgumentException("Invalid second: " + seconds);
        }
        if (milliseconds < -1 || milliseconds > 999) {
            throw new IllegalArgumentException("Invalid millisecond: " + milliseconds);
        }
        long iYear = year + 1;
        long iMonth = month == -1 ? 0L : (long)month;
        long iDay = day == -1 ? 0L : (long)day;
        long iHour = hours + 1;
        int iMinute = minutes + 1;
        int iSecond = seconds + 1;
        int iMilliseconds = milliseconds + 1;
        int iTimezone = timezone == null ? 0 : (int)((double)((timezone.getTotalSeconds() / 3600 + 12) * 2) + 0.5) + 1;
        this.value = iYear << 41 | iMonth << 36 | iDay << 31 | iHour << 26 | (long)(iMinute << 21) | (long)(iSecond << 16) | (long)(iMilliseconds << 6) | (long)iTimezone;
    }

    public FlexDateTime(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public int getYear() {
        return (int)(this.value >> 41 & 0xFFFL) - 1;
    }

    public int getMonth() {
        int iValue = (int)(this.value >> 36 & 0xFL);
        return iValue == 0 ? -1 : iValue;
    }

    public int getDay() {
        int iValue = (int)(this.value >> 31 & 0x1FL);
        return iValue == 0 ? -1 : iValue;
    }

    public int getHour() {
        return (int)(this.value >> 26 & 0x1FL) - 1;
    }

    public int getMinute() {
        return (int)(this.value >> 21 & 0x3FL) - 1;
    }

    public int getSecond() {
        return (int)(this.value >> 16 & 0x3FL);
    }

    public int getMillisecond() {
        return (int)(this.value >> 6 & 0x3FFL);
    }

    public ZoneOffset getTimezoneOffset() {
        int iValue = (int)(this.value & 0x3FL);
        if (iValue == 0) {
            return null;
        }
        double offsetValue = (double)(iValue - 1) * 0.5 - 12.0;
        return ZoneOffset.ofHoursMinutes((int)offsetValue, (int)(offsetValue * 60.0) % 60);
    }

    public OffsetDateTime getLowerBound() {
        ZoneOffset offsetValue = this.getTimezoneOffset();
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        int hour = this.getHour();
        int minute = this.getMinute();
        int second = this.getSecond();
        int millis = this.getMillisecond();
        if (year == -1) {
            return null;
        }
        if (month == -1) {
            month = 1;
        }
        if (day == -1) {
            day = 1;
        }
        if (hour == -1) {
            hour = 0;
        }
        if (minute == -1) {
            minute = 0;
        }
        if (second == -1) {
            second = 0;
        }
        if (millis == -1) {
            millis = 0;
        }
        if (offsetValue == null) {
            offsetValue = ZoneOffset.MIN;
        }
        LocalDateTime dateTime = LocalDateTime.of(year, month, day, hour, minute, second, millis * 1000000);
        return dateTime.atOffset(offsetValue);
    }

    public OffsetDateTime getUpperBound() {
        ZoneOffset offsetValue = this.getTimezoneOffset();
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        int hour = this.getHour();
        int minute = this.getMinute();
        int second = this.getSecond();
        int millis = this.getMillisecond();
        if (year == -1) {
            return null;
        }
        if (month == -1) {
            month = 12;
        }
        if (day == -1) {
            day = LocalDate.of(year, month, 1).lengthOfMonth();
        }
        if (hour == -1) {
            hour = 23;
        }
        if (minute == -1) {
            minute = 59;
        }
        if (second == -1) {
            second = 59;
        }
        if (millis == -1) {
            millis = 999;
        }
        if (offsetValue == null) {
            offsetValue = ZoneOffset.MAX;
        }
        LocalDateTime dateTime = LocalDateTime.of(year, month, day, hour, minute, second, millis * 1000000);
        return dateTime.atOffset(offsetValue);
    }
}

