/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.diff;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.openzen.zengarden.diff.ArrayDiffBuilder;
import org.openzen.zengarden.diff.DataDiff;
import org.openzen.zengarden.io.DataOutput;

public class ByteBufferDiff
implements DataDiff<ByteBuffer> {
    private final DataDiff<byte[]> byteUpdates;

    public static ByteBufferDiff create(ByteBuffer data) {
        byte[] bytes = new byte[data.limit()];
        data.get(bytes);
        return new ByteBufferDiff(ArrayDiffBuilder.BYTE.getBuilder().insert(bytes).end());
    }

    public ByteBufferDiff(DataDiff<byte[]> byteUpdates) {
        this.byteUpdates = byteUpdates;
    }

    @Override
    public ByteBuffer update(ByteBuffer value) {
        value.rewind();
        byte[] data = new byte[value.limit()];
        value.get(data);
        byte[] modified = this.byteUpdates.update(data);
        return ByteBuffer.wrap(modified);
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        this.byteUpdates.serialize(output);
    }
}

