/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDate;
import org.openzen.zengarden.util.Charsets;

public interface DataInput
extends Closeable {
    default public boolean readBoolean() throws IOException {
        return this.readUByte() != 0;
    }

    public byte readSByte() throws IOException;

    public int readUByte() throws IOException;

    public short readShort() throws IOException;

    public int readUShort() throws IOException;

    public int readInt() throws IOException;

    public int readUInt() throws IOException;

    public long readLong() throws IOException;

    public long readULong() throws IOException;

    public int readVarInt() throws IOException;

    public int readVarUInt() throws IOException;

    public long readVarLong() throws IOException;

    public long readVarULong() throws IOException;

    default public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    default public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    default public int readChar() throws IOException {
        return this.readVarUInt();
    }

    default public String readString() throws IOException {
        int size = this.readVarUInt();
        return new String(this.readRawBytes(size), Charsets.UTF_8);
    }

    default public byte[] readBytes() throws IOException {
        int size = this.readVarUInt();
        return this.readRawBytes(size);
    }

    public byte[] readRawBytes(int var1) throws IOException;

    default public boolean[] readBoolArray() throws IOException {
        int size = this.readVarUInt();
        boolean[] result = new boolean[size];
        for (int i = 0; i < (size + 7) / 8; ++i) {
            int bvalue = this.readUByte();
            int remainingBits = result.length - 8 * i;
            if (remainingBits > 0) {
                boolean bl = result[i * 8 + 0] = (bvalue & 1) > 0;
            }
            if (remainingBits > 1) {
                boolean bl = result[i * 8 + 1] = (bvalue & 2) > 0;
            }
            if (remainingBits > 2) {
                boolean bl = result[i * 8 + 2] = (bvalue & 4) > 0;
            }
            if (remainingBits > 3) {
                boolean bl = result[i * 8 + 3] = (bvalue & 8) > 0;
            }
            if (remainingBits > 4) {
                boolean bl = result[i * 8 + 4] = (bvalue & 0x10) > 0;
            }
            if (remainingBits > 5) {
                boolean bl = result[i * 8 + 5] = (bvalue & 0x20) > 0;
            }
            if (remainingBits > 6) {
                boolean bl = result[i * 8 + 6] = (bvalue & 0x40) > 0;
            }
            if (remainingBits <= 7) continue;
            result[i * 8 + 7] = (bvalue & 0x80) > 0;
        }
        return result;
    }

    default public byte[] readByteArray() throws IOException {
        return this.readBytes();
    }

    default public byte[] readUByteArray() throws IOException {
        return this.readBytes();
    }

    default public short[] readShortArray() throws IOException {
        return this.readShortArray(this.readVarUInt());
    }

    default public short[] readShortArray(int length) throws IOException {
        short[] result = new short[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    default public short[] readUShortArray() throws IOException {
        return this.readShortArray();
    }

    default public short[] readUShortArray(int length) throws IOException {
        return this.readShortArray(length);
    }

    default public int[] readVarIntArray() throws IOException {
        return this.readVarIntArray(this.readVarUInt());
    }

    default public int[] readVarIntArray(int length) throws IOException {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarInt();
        }
        return result;
    }

    default public int[] readVarUIntArray() throws IOException {
        return this.readVarUIntArray(this.readVarUInt());
    }

    default public int[] readVarUIntArray(int length) throws IOException {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarUInt();
        }
        return result;
    }

    default public int[] readIntArray() throws IOException {
        return this.readIntArray(this.readVarUInt());
    }

    default public int[] readIntArray(int length) throws IOException {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    default public int[] readUIntArray() throws IOException {
        int[] result = new int[this.readVarUInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readUInt();
        }
        return result;
    }

    default public long[] readVarLongArray() throws IOException {
        return this.readVarLongArray(this.readVarUInt());
    }

    default public long[] readVarLongArray(int length) throws IOException {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarLong();
        }
        return result;
    }

    default public long[] readVarULongArray() throws IOException {
        return this.readVarULongArray(this.readVarUInt());
    }

    default public long[] readVarULongArray(int length) throws IOException {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarULong();
        }
        return result;
    }

    default public long[] readLongArray() throws IOException {
        return this.readLongArray(this.readVarUInt());
    }

    default public long[] readLongArray(int length) throws IOException {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readLong();
        }
        return result;
    }

    default public long[] readULongArray() throws IOException {
        return this.readLongArray();
    }

    default public long[] readULongArray(int length) throws IOException {
        return this.readLongArray(length);
    }

    default public float[] readFloatArray() throws IOException {
        return this.readFloatArray(this.readVarUInt());
    }

    default public float[] readFloatArray(int length) throws IOException {
        float[] result = new float[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    default public double[] readDoubleArray() throws IOException {
        return this.readDoubleArray(this.readVarUInt());
    }

    default public double[] readDoubleArray(int length) throws IOException {
        double[] result = new double[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readDouble();
        }
        return result;
    }

    default public String[] readStringArray() throws IOException {
        return this.readStringArray(this.readVarUInt());
    }

    default public String[] readStringArray(int length) throws IOException {
        String[] result = new String[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readString();
        }
        return result;
    }

    default public LocalDate readDate() throws IOException {
        int value = this.readVarInt();
        if (value == -32) {
            return null;
        }
        int year = value / 372 + 2000;
        int monthsAndDays = value % 372;
        if (value < 0) {
            --year;
            monthsAndDays += 372;
        }
        int month = monthsAndDays / 31;
        int day = monthsAndDays % 31;
        return LocalDate.of(year, month + 1, day + 1);
    }

    public void skip(int var1) throws IOException;

    public boolean hasMore() throws IOException;
}

