/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.function.Predicate;
import org.openzen.zengarden.events.EventListener;
import org.openzen.zengarden.events.ListenerHandle;
import org.openzen.zengarden.watched.WatchedObject;
import org.openzen.zengarden.watched.event.AfterChangeEvent;
import org.openzen.zengarden.watched.event.BeforeChangeEvent;

public class GuardedObject<T>
implements WatchedObject<T> {
    private final WatchedObject<T> value;
    private final Predicate<T> test;

    public GuardedObject(WatchedObject<T> value, Predicate<T> test) {
        this.value = value;
        this.test = test;
    }

    @Override
    public T get() {
        return this.value.get();
    }

    @Override
    public void set(T value) {
        if (this.test.test(value)) {
            this.value.set(value);
        }
    }

    @Override
    public WatchedObject<T> lock() {
        return this.value.lock();
    }

    @Override
    public WatchedObject<T> guard(Predicate<T> test) {
        return new GuardedObject<T>(this, test);
    }

    @Override
    public ListenerHandle<?> whenGoingToChange(EventListener<BeforeChangeEvent<T>> listener) {
        return this.value.whenGoingToChange(listener);
    }

    @Override
    public ListenerHandle<?> whenChanged(EventListener<AfterChangeEvent<T>> listener) {
        return this.value.whenChanged(listener);
    }
}

