/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openzen.zengarden.function.Consumer;
import org.openzen.zengarden.function.Function;
import org.openzen.zengarden.index.Index;

public class AutoIndex<K, V>
implements Index<K, V> {
    private final Map<K, Set<V>> index = new HashMap<K, Set<V>>();
    private final Function<V, K> indexer;

    public AutoIndex(Function<V, K> indexer) {
        this.indexer = indexer;
    }

    public K getKey(V value) {
        return (K)this.indexer.apply(value);
    }

    public boolean add(V value) {
        Object key = this.indexer.apply(value);
        if (!this.index.containsKey(key)) {
            this.index.put(key, new HashSet());
        }
        return this.index.get(key).add(value);
    }

    public boolean remove(V value) {
        Object key = this.indexer.apply(value);
        boolean result = this.index.get(key).remove(value);
        if (this.index.get(key).isEmpty()) {
            this.index.remove(key);
        }
        return result;
    }

    @Override
    public Set<V> find(K key) {
        return this.index.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public Set<K> getKeys() {
        return this.index.keySet();
    }

    @Override
    public void forEachValue(Consumer<V> consumer) {
        for (K key : this.getKeys()) {
            for (Object value : this.find((Object)key)) {
                consumer.accept(value);
            }
        }
    }
}

