/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.mail;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.openzen.zengarden.mail.Mailer;

public class JavaMailer
implements Mailer {
    private final Session session;

    public JavaMailer(final JavaMailerProperties mailerProperties) {
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", mailerProperties.auth);
        properties.put("mail.smtp.starttls.enable", (Object)mailerProperties.enableStartTLS);
        properties.put("mail.smtp.host", mailerProperties.host);
        properties.put("mail.smtp.port", (Object)mailerProperties.port);
        this.session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(mailerProperties.username, mailerProperties.password);
            }
        });
    }

    @Override
    public void sendPlainTextEmail(String fromEmail, String toEmail, String subject, String message) {
        try {
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setFrom((Address)new InternetAddress(fromEmail));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toEmail));
            mimeMessage.setSubject(subject);
            mimeMessage.setText(message);
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendHTMLEmail(String fromEmail, String toEmail, String subject, String message) {
        try {
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setFrom((Address)new InternetAddress(fromEmail));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toEmail));
            mimeMessage.setSubject(subject);
            mimeMessage.setContent((Object)message, "text/html");
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class JavaMailerProperties {
        public String host;
        public int port;
        public String auth;
        public boolean enableStartTLS = false;
        public String username;
        public String password;
    }
}

