/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;

public abstract class ObjectArrayFunctions<T>
implements ArrayFunctions<T[]> {
    private final Class<T> cls;

    public ObjectArrayFunctions(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public T[] newArray(int length) {
        return (Object[])Array.newInstance(this.cls, length);
    }

    @Override
    public int getLength(T[] value) {
        return value.length;
    }

    @Override
    public boolean equals(T[] array1, T[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public T[] concat(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(T[] array, T[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(T[] array, T[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(T[] array1, T[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(T[] array1, T[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public T[] copyOfRange(T[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(T[] from, int fromOffset, T[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(T[] array1, int array1Index, T[] array2, int array2Index) {
        return array1[array1Index].equals(array2[array2Index]);
    }
}

