/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openzen.zengarden.function.Consumer;
import org.openzen.zengarden.index.Index;

public class UnorderedIndex<K, V>
implements Index<K, V> {
    private final Map<K, Set<V>> index = new HashMap<K, Set<V>>();

    public void put(K key, V value) {
        if (!this.index.containsKey(key)) {
            this.index.put(key, new HashSet());
        }
        this.index.get(key).add(value);
    }

    public void remove(K key, V value) {
        this.index.get(key).remove(value);
        if (this.index.get(key).isEmpty()) {
            this.index.remove(key);
        }
    }

    @Override
    public Set<V> find(K key) {
        return this.index.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public Set<K> getKeys() {
        return this.index.keySet();
    }

    @Override
    public void forEachValue(Consumer<V> consumer) {
        for (K key : this.index.keySet()) {
            for (V value : this.index.get(key)) {
                consumer.accept(value);
            }
        }
    }
}

