/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import java.io.InputStream;
import org.openzen.zengarden.io.DataInput;

public class StreamingDataInput
implements DataInput {
    private static final int P6 = 64;
    private static final int P7 = 128;
    private static final int P13 = 8192;
    private static final int P14 = 16384;
    private static final int P20 = 0x100000;
    private static final int P21 = 0x200000;
    private static final int P27 = 0x8000000;
    private static final int P28 = 0x10000000;
    private static final long P34 = 0x400000000L;
    private static final long P35 = 0x800000000L;
    private static final long P41 = 0x20000000000L;
    private static final long P42 = 0x40000000000L;
    private static final long P48 = 0x1000000000000L;
    private static final long P49 = 0x2000000000000L;
    private static final long P55 = 0x80000000000000L;
    private static final long P56 = 0x100000000000000L;
    private final InputStream input;

    public StreamingDataInput(InputStream input) {
        this.input = input;
    }

    @Override
    public byte readSByte() throws IOException {
        return (byte)this.input.read();
    }

    @Override
    public int readUByte() throws IOException {
        return this.input.read();
    }

    @Override
    public short readShort() throws IOException {
        int b0 = this.input.read();
        int b1 = this.input.read();
        return (short)(b0 << 8 | b1);
    }

    @Override
    public int readUShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() throws IOException {
        int b0 = this.input.read();
        int b1 = this.input.read();
        int b2 = this.input.read();
        int b3 = this.input.read();
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    @Override
    public int readUInt() throws IOException {
        return this.readInt();
    }

    @Override
    public long readLong() throws IOException {
        long i0 = (long)this.readInt() & 0xFFFFFFFFL;
        long i1 = (long)this.readInt() & 0xFFFFFFFFL;
        return i0 << 32 | i1;
    }

    @Override
    public long readULong() throws IOException {
        return this.readLong();
    }

    @Override
    public int readVarInt() throws IOException {
        int value = this.input.read();
        if ((value & 0x80) == 0) {
            return value - 64;
        }
        if (((value = value & 0x7F | this.input.read() << 7) & 0x4000) == 0) {
            return value - 8192;
        }
        if (((value = value & 0x3FFF | this.input.read() << 14) & 0x200000) == 0) {
            return value - 0x100000;
        }
        if (((value = value & 0x1FFFFF | this.input.read() << 21) & 0x10000000) == 0) {
            return value - 0x8000000;
        }
        return value & 0xFFFFFFF | this.input.read() << 28;
    }

    @Override
    public int readVarUInt() throws IOException {
        int value = this.input.read();
        if ((value & 0x80) == 0) {
            return value;
        }
        if (((value = value & 0x7F | this.input.read() << 7) & 0x4000) == 0) {
            return value;
        }
        if (((value = value & 0x3FFF | this.input.read() << 14) & 0x200000) == 0) {
            return value;
        }
        if (((value = value & 0x1FFFFF | this.input.read() << 21) & 0x10000000) == 0) {
            return value;
        }
        return value & 0xFFFFFFF | this.input.read() << 28;
    }

    @Override
    public long readVarLong() throws IOException {
        long value = this.input.read();
        if ((value & 0x80L) == 0L) {
            return value - 64L;
        }
        if (((value = value & 0x7FL | (long)(this.input.read() << 7)) & 0x4000L) == 0L) {
            return value - 8192L;
        }
        if (((value = value & 0x3FFFL | (long)(this.input.read() << 14)) & 0x200000L) == 0L) {
            return value - 0x100000L;
        }
        if (((value = value & 0x1FFFFFL | (long)(this.input.read() << 21)) & 0x10000000L) == 0L) {
            return value - 0x8000000L;
        }
        if (((value = value & 0xFFFFFFFL | (long)this.input.read() << 28) & 0x800000000L) == 0L) {
            return value - 0x400000000L;
        }
        if (((value = value & 0x7FFFFFFFFL | (long)this.input.read() << 35) & 0x40000000000L) == 0L) {
            return value - 0x20000000000L;
        }
        if (((value = value & 0x3FFFFFFFFFFL | (long)this.input.read() << 42) & 0x2000000000000L) == 0L) {
            return value - 0x1000000000000L;
        }
        if (((value = value & 0x1FFFFFFFFFFFFL | (long)this.input.read() << 49) & 0x100000000000000L) == 0L) {
            return value - 0x80000000000000L;
        }
        return value & 0xFFFFFFFFFFFFFFL | (long)this.input.read() << 56;
    }

    @Override
    public long readVarULong() throws IOException {
        long value = this.input.read();
        if ((value & 0x80L) == 0L) {
            return value;
        }
        if (((value = value & 0x7FL | (long)(this.input.read() << 7)) & 0x4000L) == 0L) {
            return value;
        }
        if (((value = value & 0x3FFFL | (long)(this.input.read() << 14)) & 0x200000L) == 0L) {
            return value;
        }
        if (((value = value & 0x1FFFFFL | (long)(this.input.read() << 21)) & 0x10000000L) == 0L) {
            return value;
        }
        if (((value = value & 0xFFFFFFFL | (long)this.input.read() << 28) & 0x800000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x7FFFFFFFFL | (long)this.input.read() << 35) & 0x40000000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x3FFFFFFFFFFL | (long)this.input.read() << 42) & 0x2000000000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x1FFFFFFFFFFFFL | (long)this.input.read() << 49) & 0x100000000000000L) == 0L) {
            return value;
        }
        return value & 0xFFFFFFFFFFFFFFL | (long)this.input.read() << 56;
    }

    @Override
    public byte[] readRawBytes(int size) throws IOException {
        byte[] result = new byte[size];
        for (int readSoFar = 0; readSoFar < size; readSoFar += this.input.read(result, readSoFar, size - readSoFar)) {
        }
        return result;
    }

    @Override
    public byte[] readBytes() throws IOException {
        int size = this.readVarUInt();
        return this.readRawBytes(size);
    }

    @Override
    public void skip(int bytes) throws IOException {
        this.input.skip(bytes);
    }

    @Override
    public boolean hasMore() throws IOException {
        return this.input.available() > 0;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

