/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.lexer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.openzen.zengarden.lexer.CompiledDFA;
import org.openzen.zengarden.lexer.Token;
import org.openzen.zengarden.lexer.TokenPosition;
import org.openzen.zengarden.lexer.TokenType;

public abstract class TokenStream<T extends Token<TT>, TT extends TokenType>
implements Iterator<T> {
    private final String filename;
    private final CountingReader reader;
    private final CompiledDFA<TT> dfa;
    private final LinkedList<T> tokenMemory = new LinkedList();
    private final Stack<Integer> marks = new Stack();
    private T next;
    private int nextChar;
    private int line;
    private int lineOffset;
    private int tokenMemoryOffset = 0;
    private int tokenMemoryCurrent = 0;

    public TokenStream(String filename, Reader reader, CompiledDFA<TT> dfa) {
        this.reader = new CountingReader(reader);
        this.dfa = dfa;
        this.filename = filename;
        try {
            this.nextChar = this.reader.read();
        }
        catch (IOException ex) {
            this.ioException(ex);
        }
        this.line = 1;
        this.lineOffset = 1;
        this.advance();
    }

    public TokenStream(String filename, String data, CompiledDFA<TT> dfa) {
        this(filename, new StringReader(data), dfa);
    }

    public String getFile() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public T peek() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return (T)((Token)this.tokenMemory.get(this.tokenMemoryCurrent - this.tokenMemoryOffset));
        }
        return this.next;
    }

    public boolean isNext(TT type) {
        return this.peek().getType() == type;
    }

    public T optional(TT type) {
        if (this.peek() != null && this.peek().getType() == type) {
            return (T)this.next();
        }
        return null;
    }

    public T required(TT type, String error) {
        T t = this.peek();
        if (t != null && t.getType() == type) {
            return (T)this.next();
        }
        this.requiredTokenNotFound(this.getPosition(), error);
        return null;
    }

    public TokenPosition getPosition() {
        T t = this.peek();
        if (t == null) {
            return new TokenPosition(this.filename, this.line, this.lineOffset, this.line, this.lineOffset);
        }
        return t.getPosition();
    }

    public void pushMark() {
        this.marks.push(this.tokenMemoryCurrent);
    }

    public void popMark() {
        this.marks.pop();
        if (this.marks.isEmpty()) {
            this.tokenMemoryOffset = this.tokenMemoryCurrent;
            this.tokenMemory.clear();
        }
    }

    public void reset() {
        this.tokenMemoryCurrent = this.marks.pop();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return (T)((Token)this.tokenMemory.get(this.tokenMemoryCurrent++ - this.tokenMemoryOffset));
        }
        T result = this.next;
        if (this.marks.isEmpty()) {
            ++this.tokenMemoryOffset;
        } else {
            this.tokenMemory.add(result);
        }
        ++this.tokenMemoryCurrent;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    protected abstract T createToken(TokenPosition var1, String var2, TT var3);

    protected abstract void requiredTokenNotFound(TokenPosition var1, String var2);

    protected abstract T invalidToken(TokenPosition var1, String var2);

    protected abstract void ioException(IOException var1);

    private void advance() {
        do {
            this.advanceToken();
        } while (this.next != null && this.next.getType().isWhitespace());
    }

    private void advanceToken() {
        if (this.nextChar < 0) {
            this.next = null;
            return;
        }
        try {
            int state = 0;
            StringBuilder value = new StringBuilder();
            int fromLine = this.line;
            int fromLineOffset = this.lineOffset;
            while (this.dfa.transitions[state].containsKey(this.nextChar)) {
                value.append((char)this.nextChar);
                state = this.dfa.transitions[state].get(this.nextChar);
                this.line = this.reader.line;
                this.lineOffset = this.reader.lineOffset;
                this.nextChar = this.reader.read();
            }
            if (this.line < 0) {
                throw new IllegalStateException("Line cannot be negative");
            }
            if (((TokenType[])this.dfa.finals)[state] != null) {
                if (state == 0) {
                    value.append((char)this.nextChar);
                    this.next = this.invalidToken(new TokenPosition(this.filename, fromLine, fromLineOffset, this.line, this.lineOffset), value.toString());
                    this.nextChar = this.reader.read();
                }
                this.next = this.createToken(new TokenPosition(this.filename, fromLine, fromLineOffset, this.line, this.lineOffset), value.toString(), ((TokenType[])this.dfa.finals)[state]);
            } else {
                if (this.nextChar < 0 && value.length() == 0) {
                    return;
                }
                value.append((char)this.nextChar);
                this.next = this.invalidToken(new TokenPosition(this.filename, fromLine, fromLineOffset, this.line, this.lineOffset), value.toString());
                this.nextChar = this.reader.read();
            }
        }
        catch (IOException ex) {
            this.ioException(ex);
        }
    }

    private class CountingReader {
        private int line;
        private int lineOffset;
        private Reader reader;
        private boolean eof;

        public CountingReader(Reader reader) {
            this.reader = reader;
            this.line = 1;
            this.lineOffset = 1;
        }

        public int read() throws IOException {
            int ch = this.reader.read();
            if (ch == -1) {
                this.eof = true;
                return ch;
            }
            if (ch == 10) {
                ++this.line;
                this.lineOffset = 1;
            } else {
                ++this.lineOffset;
            }
            return ch;
        }
    }
}

