/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.function.IntPredicate;
import org.openzen.zengarden.watched.AbstractWatchedValue;
import org.openzen.zengarden.watched.GuardedInt;
import org.openzen.zengarden.watched.LockedInt;
import org.openzen.zengarden.watched.WatchedInt;

public class BasicWatchedInt
extends AbstractWatchedValue<Integer>
implements WatchedInt {
    private volatile int value;

    public BasicWatchedInt(int initialValue) {
        this.value = initialValue;
    }

    @Override
    public int get() {
        return this.value;
    }

    @Override
    public void set(int value) {
        int oldValue = this.value;
        if (!this.onBeforeChange(oldValue, value)) {
            this.value = value;
            this.onChanged(oldValue, this.value);
        }
    }

    public void or(int value) {
        this.set(this.value | value);
    }

    public void and(int value) {
        this.set(this.value & value);
    }

    @Override
    public WatchedInt lock() {
        return new LockedInt(this);
    }

    @Override
    public WatchedInt guard(IntPredicate test) {
        return new GuardedInt(this, test);
    }
}

