/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import org.openzen.zengarden.collections.ZArrayList;
import org.openzen.zengarden.collections.ZCollection;
import org.openzen.zengarden.collections.ZEmptyList;
import org.openzen.zengarden.collections.ZFixedList;
import org.openzen.zengarden.function.Function;
import org.openzen.zengarden.function.Predicate;
import org.openzen.zengarden.watched.BasicWatchedList;
import org.openzen.zengarden.watched.WatchedList;

public interface ZList<T>
extends ZCollection<T> {
    public static <T> ZList<T> empty(Class<T> cls) {
        return new ZEmptyList<T>(cls);
    }

    public static <T> ZList<T> fixed(T[] array) {
        return new ZFixedList<T>(array);
    }

    public boolean add(int var1, T var2);

    public T remove(int var1);

    public T get(int var1);

    public T set(int var1, T var2);

    public int indexOf(T var1);

    public int lastIndexOf(T var1);

    @Override
    default public <U> ZList<U> map(Class<U> type, Function<T, U> converter) {
        ZArrayList<U> result = new ZArrayList<U>(type);
        for (Object value : this) {
            result.add(converter.apply(value));
        }
        return result;
    }

    @Override
    default public ZList<T> filter(Predicate<T> predicate) {
        ZArrayList result = new ZArrayList(this.getElementClass());
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    default public boolean contains(T value) {
        return this.indexOf(value) > 0;
    }

    default public WatchedList<T> watch() {
        return new BasicWatchedList(this);
    }

    default public T first(Predicate<T> predicate) {
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            return value;
        }
        return null;
    }

    default public T last(Predicate<T> predicate) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!predicate.test(this.get(i))) continue;
            return this.get(i);
        }
        return null;
    }
}

