/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.promise;

import org.openzen.zengarden.function.Consumer;
import org.openzen.zengarden.promise.Promise;

public class RejectedPromise<R, S, E extends Throwable>
implements Promise<R, S, E> {
    private final E exception;

    public RejectedPromise(E exception) {
        this(exception, runnable -> runnable.run());
    }

    public RejectedPromise(E exception, Consumer<Runnable> runner) {
        this.exception = exception;
    }

    @Override
    public Class<E> getErrorClass() {
        return this.exception.getClass();
    }

    @Override
    public Promise<R, S, E> onDone(Consumer<R> consumer) {
        return this;
    }

    @Override
    public Promise<R, S, E> onCached(Consumer<R> consumer) {
        return this;
    }

    @Override
    public Promise<R, S, E> onStatus(Consumer<S> consumer) {
        return this;
    }

    @Override
    public Promise<R, S, E> onFail(Consumer<E> consumer) {
        consumer.accept(this.exception);
        return this;
    }

    @Override
    public R get() throws E {
        throw this.exception;
    }
}

