/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.openzen.zengarden.function.Function;
import org.openzen.zengarden.function.Predicate;
import org.openzen.zengarden.function.ToDoubleFunction;
import org.openzen.zengarden.function.ToIntFunction;
import org.openzen.zengarden.function.ToLongFunction;
import org.openzen.zengarden.util.ZObjects;

public class ZArrays {
    private ZArrays() {
    }

    public static <T> int indexOf(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            if (!ZObjects.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!ZObjects.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static int sum(int[] array) {
        int sum = 0;
        for (int value : array) {
            sum += value;
        }
        return sum;
    }

    public static float sum(float[] array) {
        float sum = 0.0f;
        for (float value : array) {
            sum += value;
        }
        return sum;
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        for (double value : array) {
            sum += value;
        }
        return sum;
    }

    public static <T> int sumForInt(T[] array, ToIntFunction<T> function) {
        int sum = 0;
        for (T element : array) {
            sum += function.applyAsInt(element);
        }
        return sum;
    }

    public static <T> double sumForDouble(T[] array, ToDoubleFunction<T> function) {
        double sum = 0.0;
        for (T element : array) {
            sum += function.applyAsDouble(element);
        }
        return sum;
    }

    public static <T> Set<T> asSet(T[] array) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(Arrays.asList(array));
        return set;
    }

    public static <T, R> R[] map(Class<R> component, T[] array, Function<T, R> function) {
        Object[] newArray = (Object[])Array.newInstance(component, array.length);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = function.apply(array[i]);
        }
        return newArray;
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate) {
        T[] newArray = Arrays.copyOf(array, array.length);
        int results = 0;
        for (T value : array) {
            if (!predicate.test(value)) continue;
            newArray[results++] = value;
        }
        return Arrays.copyOf(newArray, results);
    }

    public static <T> T first(T[] array, Predicate<T> predicate) {
        for (T value : array) {
            if (!predicate.test(value)) continue;
            return value;
        }
        return null;
    }

    public static <T> T last(T[] array, Predicate<T> predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return array[i];
        }
        return null;
    }

    public static int min(int[] array) {
        int min = Integer.MAX_VALUE;
        for (int value : array) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static long min(long[] array) {
        long min = Long.MAX_VALUE;
        for (long value : array) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static float min(float[] array) {
        float min = Float.POSITIVE_INFINITY;
        for (float value : array) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    public static double min(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        for (double value : array) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    public static <T> T min(T[] array, Comparator<T> comparator) {
        Object minValue = null;
        for (T value : array) {
            if (minValue != null && comparator.compare(value, minValue) >= 0) continue;
            minValue = value;
        }
        return minValue;
    }

    public static <T> T minForInt(T[] array, ToIntFunction<T> function) {
        int min = Integer.MAX_VALUE;
        T minValue = null;
        for (T value : array) {
            int ivalue = function.applyAsInt(value);
            if (ivalue >= min) continue;
            min = ivalue;
            minValue = value;
        }
        return minValue;
    }

    public static <T> T minForLong(T[] array, ToLongFunction<T> function) {
        long min = Long.MAX_VALUE;
        T minValue = null;
        for (T value : array) {
            long ivalue = function.applyAsLong(value);
            if (ivalue >= min) continue;
            min = ivalue;
            minValue = value;
        }
        return minValue;
    }

    public static <T> T minForDouble(T[] array, ToDoubleFunction<T> function) {
        double min = Double.POSITIVE_INFINITY;
        T minValue = null;
        for (T value : array) {
            double dvalue = function.applyAsDouble(value);
            if (!(dvalue < min)) continue;
            min = dvalue;
            minValue = value;
        }
        return minValue;
    }

    public static <T> int minInt(T[] array, ToIntFunction<T> function) {
        int min = Integer.MAX_VALUE;
        for (T value : array) {
            int ivalue = function.applyAsInt(value);
            if (ivalue >= min) continue;
            min = ivalue;
        }
        return min;
    }

    public static <T> long minLong(T[] array, ToLongFunction<T> function) {
        long min = Long.MAX_VALUE;
        for (T value : array) {
            long lvalue = function.applyAsLong(value);
            if (lvalue >= min) continue;
            min = lvalue;
        }
        return min;
    }

    public static <T> double minDouble(T[] array, ToDoubleFunction<T> function) {
        double min = Double.POSITIVE_INFINITY;
        for (T value : array) {
            double dvalue = function.applyAsDouble(value);
            if (!(dvalue < min)) continue;
            min = dvalue;
        }
        return min;
    }

    public static char max(char[] chars) {
        char max = '\u0000';
        for (char c : chars) {
            if (c <= max) continue;
            max = c;
        }
        return max;
    }

    public static int max(int[] array) {
        int max = Integer.MIN_VALUE;
        for (int value : array) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static long max(long[] array) {
        long max = Long.MIN_VALUE;
        for (long value : array) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static float max(float[] array) {
        float max = Float.NEGATIVE_INFINITY;
        for (float value : array) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public static double max(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        for (double value : array) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public static <T> T max(T[] array, Comparator<T> comparator) {
        Object maxValue = null;
        for (T value : array) {
            if (maxValue != null && comparator.compare(value, maxValue) <= 0) continue;
            maxValue = value;
        }
        return maxValue;
    }

    public static <T> T maxForInt(T[] array, ToIntFunction<T> function) {
        int max = Integer.MIN_VALUE;
        T maxValue = null;
        for (T value : array) {
            int ivalue = function.applyAsInt(value);
            if (ivalue <= max) continue;
            max = ivalue;
            maxValue = value;
        }
        return maxValue;
    }

    public static <T> T maxForLong(T[] array, ToLongFunction<T> function) {
        long max = Long.MIN_VALUE;
        T maxValue = null;
        for (T value : array) {
            long ivalue = function.applyAsLong(value);
            if (ivalue <= max) continue;
            max = ivalue;
            maxValue = value;
        }
        return maxValue;
    }

    public static <T> T maxForDouble(T[] array, ToDoubleFunction<T> function) {
        double max = Double.NEGATIVE_INFINITY;
        T maxValue = null;
        for (T value : array) {
            double dvalue = function.applyAsDouble(value);
            if (!(dvalue > max)) continue;
            max = dvalue;
            maxValue = value;
        }
        return maxValue;
    }

    public static <T> int maxInt(T[] array, ToIntFunction<T> function) {
        int max = Integer.MIN_VALUE;
        for (T value : array) {
            int ivalue = function.applyAsInt(value);
            if (ivalue <= max) continue;
            max = ivalue;
        }
        return max;
    }

    public static <T> long maxLong(T[] array, ToLongFunction<T> function) {
        long max = Long.MIN_VALUE;
        for (T value : array) {
            long lvalue = function.applyAsLong(value);
            if (lvalue <= max) continue;
            max = lvalue;
        }
        return max;
    }

    public static <T> double maxDouble(T[] array, ToDoubleFunction<T> function) {
        double max = Double.NEGATIVE_INFINITY;
        for (T value : array) {
            double dvalue = function.applyAsDouble(value);
            if (!(dvalue > max)) continue;
            max = dvalue;
        }
        return max;
    }
}

