/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import org.openzen.zengarden.io.DataOutput;
import org.openzen.zengarden.io.Serializer;
import org.openzen.zengarden.util.Charsets;
import org.openzen.zengarden.util.FlexDateTime;

public class StreamingDataOutput
implements DataOutput {
    private static final int P6 = 64;
    private static final int P7 = 128;
    private static final int P13 = 8192;
    private static final int P14 = 16384;
    private static final int P20 = 0x100000;
    private static final int P21 = 0x200000;
    private static final int P27 = 0x8000000;
    private static final int P28 = 0x10000000;
    private static final long P34 = 0x400000000L;
    private static final long P35 = 0x800000000L;
    private static final long P41 = 0x20000000000L;
    private static final long P42 = 0x40000000000L;
    private static final long P48 = 0x1000000000000L;
    private static final long P49 = 0x2000000000000L;
    private static final long P55 = 0x80000000000000L;
    private static final long P56 = 0x100000000000000L;
    private OutputStream output;

    public StreamingDataOutput(OutputStream output) {
        this.output = output;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeUByte(value ? 1 : 0);
    }

    @Override
    public void writeSByte(byte value) throws IOException {
        this.output.write(value);
    }

    @Override
    public void writeUByte(int value) throws IOException {
        this.writeSByte((byte)value);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.output.write(value >>> 8);
        this.output.write(value);
    }

    @Override
    public void writeUShort(int value) throws IOException {
        this.writeShort((short)value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.output.write(value >>> 24);
        this.output.write(value >>> 16);
        this.output.write(value >>> 8);
        this.output.write(value);
    }

    @Override
    public void writeUInt(int value) throws IOException {
        this.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.output.write((byte)(value >>> 56));
        this.output.write((byte)(value >>> 48));
        this.output.write((byte)(value >>> 40));
        this.output.write((byte)(value >>> 32));
        this.output.write((byte)(value >>> 24));
        this.output.write((byte)(value >>> 16));
        this.output.write((byte)(value >>> 8));
        this.output.write((byte)value);
    }

    @Override
    public void writeULong(long value) throws IOException {
        this.writeLong(value);
    }

    @Override
    public void writeVarInt(int value) throws IOException {
        if (value >= -64 && value < 64) {
            this.output.write((byte)((value += 64) & 0x7F));
        } else if (value >= -8192 && value < 8192) {
            this.output.write((byte)((value += 8192) & 0x7F | 0x80));
            this.output.write((byte)(value >> 7 & 0x7F));
        } else if (value >= -1048576 && value < 0x100000) {
            this.output.write((byte)((value += 0x100000) & 0x7F | 0x80));
            this.output.write((byte)(value >> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >> 14 & 0x7F));
        } else if (value >= -134217728 && value < 0x8000000) {
            this.output.write((byte)((value += 0x8000000) & 0x7F | 0x80));
            this.output.write((byte)(value >> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >> 14 & 0x7F | 0x80));
            this.output.write((byte)(value >> 21 & 0x7F));
        } else {
            this.output.write((byte)(value & 0x7F | 0x80));
            this.output.write((byte)(value >>> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 14 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 21 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 28 & 0x7F));
        }
    }

    @Override
    public void writeVarUInt(int value) throws IOException {
        if (value >= 0 && value < 0x10000000) {
            if (value < 128) {
                this.output.write((byte)(value & 0x7F));
            } else if (value < 16384) {
                this.output.write((byte)(value & 0x7F | 0x80));
                this.output.write((byte)(value >> 7 & 0x7F));
            } else if (value < 0x200000) {
                this.output.write((byte)(value & 0x7F | 0x80));
                this.output.write((byte)(value >> 7 & 0x7F | 0x80));
                this.output.write((byte)(value >> 14 & 0x7F));
            } else {
                this.output.write((byte)(value & 0x7F | 0x80));
                this.output.write((byte)(value >> 7 & 0x7F | 0x80));
                this.output.write((byte)(value >> 14 & 0x7F | 0x80));
                this.output.write((byte)(value >> 21 & 0x7F));
            }
        } else {
            this.output.write((byte)(value & 0x7F | 0x80));
            this.output.write((byte)(value >>> 7 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 14 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 21 & 0x7F | 0x80));
            this.output.write((byte)(value >>> 28 & 0x7F));
        }
    }

    @Override
    public void writeVarLong(long value) throws IOException {
        if (value >= -64L && value < 64L) {
            this.output.write((byte)((value += 64L) & 0x7FL));
        } else if (value >= -8192L && value < 8192L) {
            this.output.write((byte)((value += 8192L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL));
        } else if (value >= -1048576L && value < 0x100000L) {
            this.output.write((byte)((value += 0x100000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL));
        } else if (value >= -134217728L && value < 0x8000000L) {
            this.output.write((byte)((value += 0x8000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL));
        } else if (value >= -17179869184L && value < 0x400000000L) {
            this.output.write((byte)((value += 0x400000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL));
        } else if (value >= -2199023255552L && value < 0x40000000000L) {
            this.output.write((byte)((value += 0x20000000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 35 & 0x7FL));
        } else if (value >= -281474976710656L && value < 0x1000000000000L) {
            this.output.write((byte)((value += 0x1000000000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 42 & 0x7FL));
        } else if (value >= -36028797018963968L && value < 0x80000000000000L) {
            this.output.write((byte)((value += 0x80000000000000L) & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 42 & 0x7FL | 0x80L));
            this.output.write((byte)(value >> 49 & 0x7FL));
        } else {
            this.output.write((byte)(value & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 42 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 49 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 56));
        }
    }

    @Override
    public void writeVarULong(long value) throws IOException {
        if (value >= 0L && value < 0x100000000000000L) {
            if (value < 128L) {
                this.output.write((byte)(value & 0x7FL));
            } else if (value < 16384L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL));
            } else if (value < 0x200000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL));
            } else if (value < 0x10000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL));
            } else if (value < 0x800000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL));
            } else if (value < 0x40000000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 35 & 0x7FL));
            } else if (value < 0x2000000000000L) {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 42 & 0x7FL));
            } else {
                this.output.write((byte)(value & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 7 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 14 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 21 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 28 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 35 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 42 & 0x7FL | 0x80L));
                this.output.write((byte)(value >> 49 & 0x7FL));
            }
        } else {
            this.output.write((byte)(value & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 7 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 14 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 21 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 28 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 35 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 42 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 49 & 0x7FL | 0x80L));
            this.output.write((byte)(value >>> 56));
        }
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.writeVarUInt(value);
    }

    @Override
    public void writeBytes(byte[] data) throws IOException {
        this.writeVarUInt(data.length);
        this.writeRawBytes(data);
    }

    @Override
    public void writeBytes(byte[] data, int offset, int length) throws IOException {
        this.writeVarUInt(length);
        this.writeRawBytes(data, offset, length);
    }

    @Override
    public void writeAllBytes(ByteBuffer value) throws IOException {
        value.rewind();
        byte[] tmp = new byte[value.capacity()];
        value.get(tmp);
        this.writeBytes(tmp);
    }

    @Override
    public void writeBytes(ByteBuffer value, int length) throws IOException {
        this.writeVarUInt(length);
        this.writeRawBytes(value, length);
    }

    @Override
    public void writeRawBytes(byte[] value) throws IOException {
        this.output.write(value);
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.output.write(value, offset, length);
    }

    @Override
    public void writeRawBytes(ByteBuffer value, int length) throws IOException {
        byte[] tmp = new byte[length];
        value.get(tmp, 0, length);
        this.writeRawBytes(tmp);
    }

    @Override
    public void writeBoolArray(boolean[] data) throws IOException {
        Serializer.BOOLARRAY.serialize(this, data);
    }

    @Override
    public void writeByteArray(byte[] data) throws IOException {
        this.writeBytes(data);
    }

    @Override
    public void writeUByteArray(byte[] data) throws IOException {
        this.writeBytes(data);
    }

    @Override
    public void writeShortArray(short[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (short element : data) {
            this.writeShort(element);
        }
    }

    @Override
    public void writeShortArrayRaw(short[] data) throws IOException {
        for (short element : data) {
            this.writeShort(element);
        }
    }

    @Override
    public void writeUShortArray(short[] data) throws IOException {
        this.writeShortArray(data);
    }

    @Override
    public void writeUShortArrayRaw(short[] data) throws IOException {
        this.writeShortArrayRaw(data);
    }

    @Override
    public void writeVarIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeVarInt(element);
        }
    }

    @Override
    public void writeVarIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeVarInt(element);
        }
    }

    @Override
    public void writeVarUIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeVarUInt(element);
        }
    }

    @Override
    public void writeVarUIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeVarUInt(element);
        }
    }

    @Override
    public void writeIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeInt(element);
        }
    }

    @Override
    public void writeIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeInt(element);
        }
    }

    @Override
    public void writeUIntArray(int[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (int element : data) {
            this.writeUInt(element);
        }
    }

    @Override
    public void writeUIntArrayRaw(int[] data) throws IOException {
        for (int element : data) {
            this.writeUInt(element);
        }
    }

    @Override
    public void writeVarLongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeVarLong(element);
        }
    }

    @Override
    public void writeVarLongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeVarLong(element);
        }
    }

    @Override
    public void writeVarULongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeVarULong(element);
        }
    }

    @Override
    public void writeVarULongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeVarULong(element);
        }
    }

    @Override
    public void writeLongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeLong(element);
        }
    }

    @Override
    public void writeLongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeLong(element);
        }
    }

    @Override
    public void writeULongArray(long[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (long element : data) {
            this.writeULong(element);
        }
    }

    @Override
    public void writeULongArrayRaw(long[] data) throws IOException {
        for (long element : data) {
            this.writeULong(element);
        }
    }

    @Override
    public void writeFloatArray(float[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (float element : data) {
            this.writeFloat(element);
        }
    }

    @Override
    public void writeFloatArrayRaw(float[] data) throws IOException {
        for (float element : data) {
            this.writeFloat(element);
        }
    }

    @Override
    public void writeDoubleArray(double[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (double element : data) {
            this.writeDouble(element);
        }
    }

    @Override
    public void writeDoubleArrayRaw(double[] data) throws IOException {
        for (double element : data) {
            this.writeDouble(element);
        }
    }

    @Override
    public void writeStringArray(String[] data) throws IOException {
        this.writeVarUInt(data.length);
        for (String element : data) {
            this.writeString(element);
        }
    }

    @Override
    public void writeStringArrayRaw(String[] data) throws IOException {
        for (String element : data) {
            this.writeString(element);
        }
    }

    @Override
    public void writeString(String str) throws IOException {
        this.writeBytes(str.getBytes(Charsets.UTF_8));
    }

    @Override
    public void writeDate(LocalDate value) throws IOException {
        if (value == null) {
            this.writeVarInt(-32);
            return;
        }
        int ivalue = value.getYear() - 2000;
        ivalue = ivalue * 12 * 31 + (value.getMonthValue() - 1) * 31 + value.getDayOfMonth() - 1;
        this.writeVarInt(ivalue);
    }

    @Override
    public void writeFlexDateTime(FlexDateTime value) throws IOException {
        this.writeULong(value.getValue());
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

