/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openzen.zengarden.collections.ZArrayList;
import org.openzen.zengarden.util.Charsets;
import org.openzen.zengarden.util.StringTemplate;

public class Strings {
    private static final Map<String, CharacterEntity> NAMED_CHARACTER_ENTITIES;
    private static final Pattern MATCH_ACCENTS;

    private Strings() {
    }

    public static byte[] sha256Hash(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(value.getBytes(Charsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Strings.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String stripAccents(String str) {
        String normalized = Normalizer.normalize(str, Normalizer.Form.NFD);
        Matcher matcher = MATCH_ACCENTS.matcher(normalized);
        return matcher.replaceAll("");
    }

    public static String join(String separator, String ... values) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(value);
        }
        return result.toString();
    }

    public static String join(String separator, Iterable<String> values) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(value);
        }
        return result.toString();
    }

    public static String[] split(String value, char delimiter) {
        if (value == null) {
            return null;
        }
        ZArrayList<String> result = new ZArrayList<String>(String.class);
        int start = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != delimiter) continue;
            result.add(value.substring(start, i));
            start = i + 1;
        }
        result.add(value.substring(start));
        return result.toArray();
    }

    public static String[] split(String value, char delimiter, int max) {
        if (value == null) {
            return null;
        }
        ZArrayList<String> result = new ZArrayList<String>(String.class);
        int start = 0;
        for (int i = 0; i < value.length() && result.size() < max - 1; ++i) {
            if (value.charAt(i) != delimiter) continue;
            result.add(value.substring(start, i));
            start = i + 1;
        }
        result.add(value.substring(start));
        return result.toArray();
    }

    public static String capitalizeFirstLetter(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return value.substring(0, 1).toUpperCase(Locale.US) + value.substring(1);
    }

    public static int getCommonPrefixLength(String a, String b) {
        int result;
        int limit = Math.min(a.length(), b.length());
        for (result = 0; result < limit && a.charAt(result) == b.charAt(result); ++result) {
        }
        return result;
    }

    public static int getCommonSuffixLength(String a, String b) {
        int result;
        int limit = Math.min(a.length(), b.length());
        for (result = 0; result < limit && a.charAt(a.length() - result - 1) == b.charAt(b.length() - result - 1); ++result) {
        }
        return result;
    }

    public static String lpad(String value, int length, char c) {
        if (value.length() >= length) {
            return value;
        }
        return Strings.times(c, length - value.length()) + value;
    }

    public static String rpad(String value, int length, char c) {
        if (value.length() >= length) {
            return value;
        }
        return value + Strings.times(c, length - value.length());
    }

    public static String fillTemplate(String template, Map<String, String> values) {
        int closeIndex;
        StringBuilder result = new StringBuilder();
        int index = 0;
        int openIndex = template.indexOf("${", index);
        while (openIndex >= 0 && (closeIndex = template.indexOf(125, openIndex + 2)) >= 0) {
            String varname = template.substring(openIndex + 2, closeIndex);
            String filled = values.get(varname);
            result.append(template, index, openIndex);
            result.append(filled == null ? varname : filled);
            index = closeIndex + 1;
            openIndex = template.indexOf("${", index);
        }
        result.append(template, index, template.length());
        return result.toString();
    }

    public static StringTemplate template(String template) {
        return new StringTemplate(template);
    }

    public static String times(char c, int count) {
        char[] value = new char[count];
        for (int i = 0; i < count; ++i) {
            value[i] = c;
        }
        return new String(value);
    }

    public static String unescape(String escapedString) {
        boolean isLiteral;
        if (escapedString.length() < 2) {
            throw new IllegalArgumentException("String is not quoted");
        }
        boolean bl = isLiteral = escapedString.charAt(0) == '@';
        if (isLiteral) {
            escapedString = escapedString.substring(1);
        }
        if (escapedString.charAt(0) != '\"' && escapedString.charAt(0) != '\'') {
            throw new IllegalArgumentException("String is not quoted");
        }
        char quoteCharacter = escapedString.charAt(0);
        if (escapedString.charAt(escapedString.length() - 1) != quoteCharacter) {
            throw new IllegalArgumentException("Unbalanced quotes");
        }
        if (isLiteral) {
            return escapedString.substring(1, escapedString.length() - 1);
        }
        StringBuilder result = new StringBuilder(escapedString.length() - 2);
        block12: for (int i = 1; i < escapedString.length() - 1; ++i) {
            if (escapedString.charAt(i) == '\\') {
                if (i >= escapedString.length() - 1) {
                    throw new IllegalArgumentException("Unfinished escape sequence");
                }
                switch (escapedString.charAt(i + 1)) {
                    case '\\': {
                        ++i;
                        result.append('\\');
                        continue block12;
                    }
                    case '&': {
                        CharacterEntity characterEntity = Strings.readCharacterEntity(escapedString, i + 1);
                        i += characterEntity.stringValue.length() + 2;
                        result.append(characterEntity.charValue);
                        continue block12;
                    }
                    case 't': {
                        ++i;
                        result.append('\t');
                        continue block12;
                    }
                    case 'r': {
                        ++i;
                        result.append('\r');
                        continue block12;
                    }
                    case 'n': {
                        ++i;
                        result.append('\n');
                        continue block12;
                    }
                    case 'b': {
                        ++i;
                        result.append('\b');
                        continue block12;
                    }
                    case 'f': {
                        ++i;
                        result.append('\f');
                        continue block12;
                    }
                    case '\"': {
                        ++i;
                        result.append('\"');
                        continue block12;
                    }
                    case '\'': {
                        ++i;
                        result.append('\'');
                        continue block12;
                    }
                    case 'u': {
                        if (i >= escapedString.length() - 5) {
                            throw new IllegalArgumentException("Unfinished escape sequence");
                        }
                        int hex0 = Strings.readHexCharacter(escapedString.charAt(i + 2));
                        int hex1 = Strings.readHexCharacter(escapedString.charAt(i + 3));
                        int hex2 = Strings.readHexCharacter(escapedString.charAt(i + 4));
                        int hex3 = Strings.readHexCharacter(escapedString.charAt(i + 5));
                        i += 5;
                        result.append(hex0 << 12 | hex1 << 8 | hex2 << 4 | hex3);
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal escape sequence");
                    }
                }
            }
            result.append(escapedString.charAt(i));
        }
        return result.toString();
    }

    public static String escape(String value, char quote, boolean escapeUnicode) {
        StringBuilder output = new StringBuilder();
        output.append(quote);
        block7: for (char c : value.toCharArray()) {
            switch (c) {
                case '\"': {
                    if (quote != '\"') continue block7;
                    output.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    if (quote != '\'') continue block7;
                    output.append("\\'");
                    continue block7;
                }
                case '\n': {
                    output.append("\\n");
                    continue block7;
                }
                case '\r': {
                    output.append("\\r");
                    continue block7;
                }
                case '\t': {
                    output.append("\\t");
                    continue block7;
                }
                default: {
                    if (escapeUnicode && c > '\u007f') {
                        output.append("\\u");
                        output.append(Strings.lpad(Integer.toHexString(c), 4, '0'));
                        continue block7;
                    }
                    output.append(c);
                }
            }
        }
        output.append(quote);
        return output.toString();
    }

    public static int readHexCharacter(char hex) {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        if (hex >= 'a' && hex <= 'f') {
            return hex - 97 + 10;
        }
        throw new IllegalArgumentException("Illegal hex character: " + hex);
    }

    public static Collection<CharacterEntity> getNamedCharacterEntities() {
        return NAMED_CHARACTER_ENTITIES.values();
    }

    public static CharacterEntity readCharacterEntity(String str, int offset) {
        if (offset + 3 >= str.length()) {
            throw new IllegalArgumentException("Not a proper character entity");
        }
        if (str.charAt(offset) != '&') {
            throw new IllegalArgumentException("Not a proper character entity");
        }
        int semi = str.indexOf(59, offset);
        if (semi < 0) {
            throw new IllegalArgumentException("Not a proper character entity");
        }
        String entity = str.substring(offset + 1, semi);
        if (entity.isEmpty()) {
            throw new IllegalArgumentException("Not a proper character entity");
        }
        if (NAMED_CHARACTER_ENTITIES.containsKey(entity)) {
            return NAMED_CHARACTER_ENTITIES.get(entity);
        }
        if (entity.charAt(0) == '#') {
            if (entity.length() < 2) {
                throw new IllegalArgumentException("Not a proper character entity");
            }
            if (str.charAt(1) == 'x') {
                if (entity.length() != 7) {
                    throw new IllegalArgumentException("Not a proper character entity");
                }
                int ivalue = Integer.parseInt(entity.substring(2), 16);
                return new CharacterEntity(entity, (char)ivalue);
            }
            int ivalue = Integer.parseInt(entity.substring(1));
            return new CharacterEntity(entity, (char)ivalue);
        }
        throw new IllegalArgumentException("Not a valid named character entity");
    }

    static {
        MATCH_ACCENTS = Pattern.compile("\\p{M}");
        NAMED_CHARACTER_ENTITIES = new HashMap<String, CharacterEntity>();
        Properties properties = new Properties();
        try {
            properties.load(String.class.getResourceAsStream("/org/openzen/zengarden/characterEntities.properties"));
        }
        catch (IOException ex) {
            Logger.getLogger(Strings.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Object okey : properties.keySet()) {
            String key = okey.toString();
            char value = (char)Integer.parseInt(properties.getProperty(key));
            CharacterEntity entity = new CharacterEntity(key, value);
            NAMED_CHARACTER_ENTITIES.put(entity.stringValue, entity);
        }
    }

    public static class CharacterEntity {
        public char charValue;
        public String stringValue;

        public CharacterEntity(String stringValue, char charValue) {
            this.charValue = charValue;
            this.stringValue = stringValue;
        }
    }
}

