/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.util.Iterator;
import org.openzen.zengarden.collections.ZCollection;
import org.openzen.zengarden.function.Function;

public class ZMappedCollection<T, U>
implements ZCollection<U> {
    private final Class<U> type;
    private final ZCollection<T> original;
    private final Function<T, U> function;
    private final Function<U, T> backwardsFunction;

    public ZMappedCollection(Class<U> type, ZCollection<T> original, Function<T, U> function) {
        this(type, original, function, null);
    }

    public ZMappedCollection(Class<U> type, ZCollection<T> original, Function<T, U> function, Function<U, T> backwardsFunction) {
        this.type = type;
        this.original = original;
        this.function = function;
        this.backwardsFunction = backwardsFunction;
    }

    @Override
    public Class<U> getElementClass() {
        return this.type;
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public Iterator<U> iterator() {
        return new MappedIterator();
    }

    @Override
    public boolean add(U e) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot add without backwards function");
        }
        return this.original.add(this.backwardsFunction.apply(e));
    }

    @Override
    public boolean remove(U o) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot remove without backwards function");
        }
        return this.original.remove(this.backwardsFunction.apply(o));
    }

    @Override
    public boolean contains(U o) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot check containment without backwards function");
        }
        return this.original.contains(this.backwardsFunction.apply(o));
    }

    @Override
    public boolean addAll(Iterable<? extends U> c) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot add without backwards function");
        }
        boolean result = false;
        for (U value : c) {
            result |= this.original.add(this.backwardsFunction.apply(value));
        }
        return result;
    }

    @Override
    public boolean removeAll(Iterable<? extends U> c) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot add without backwards function");
        }
        boolean result = false;
        for (U value : c) {
            result |= this.original.contains(this.backwardsFunction.apply(value));
        }
        return result;
    }

    @Override
    public void clear() {
        this.original.clear();
    }

    private class MappedIterator
    implements Iterator<U> {
        private final Iterator<T> originalIterator;

        private MappedIterator() {
            this.originalIterator = ZMappedCollection.this.original.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.originalIterator.hasNext();
        }

        @Override
        public U next() {
            return ZMappedCollection.this.function.apply(this.originalIterator.next());
        }

        @Override
        public void remove() {
            this.originalIterator.remove();
        }
    }
}

