/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.promise;

import java.util.LinkedList;
import org.openzen.zengarden.function.Consumer;
import org.openzen.zengarden.promise.Promise;

public class Deferred<T, S, E extends Throwable> {
    private final Class<E> errorClass;
    private final Consumer<Runnable> runner;
    private boolean resolved;
    private T result = null;
    private boolean cached;
    private T cachedValue = null;
    private boolean errored;
    private E error = null;
    private final MyPromise promise = new MyPromise();

    public Deferred(Class<E> errorClass) {
        this(errorClass, runnable -> runnable.run());
    }

    public Deferred(Class<E> errorClass, Consumer<Runnable> runner) {
        this.errorClass = errorClass;
        this.runner = runner;
    }

    public void cached(T cachedValue) {
        if (this.resolved || this.errored) {
            throw new IllegalStateException(this.resolved ? "Already resolved" : "Already errored");
        }
        this.cached = true;
        this.cachedValue = cachedValue;
        for (Consumer consumer : this.promise.cachedConsumers) {
            this.runner.accept(() -> consumer.accept(this.result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(T response) {
        if (this.resolved || this.errored) {
            throw new IllegalStateException(this.resolved ? "Already resolved" : "Already errored");
        }
        this.resolved = true;
        this.result = response;
        for (Consumer consumer : this.promise.consumers) {
            this.runner.accept(() -> consumer.accept(this.result));
        }
        if (this.promise.waiting) {
            MyPromise myPromise = this.promise;
            synchronized (myPromise) {
                this.promise.notifyAll();
            }
        }
        this.promise.cachedConsumers.clear();
        this.promise.consumers.clear();
        this.promise.failures.clear();
    }

    public void status(S status) {
        for (Consumer statusReceiver : this.promise.statusReceivers) {
            this.runner.accept(() -> statusReceiver.accept(status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(E error) {
        if (this.resolved || this.errored) {
            throw new IllegalStateException(this.resolved ? "Already resolved" : "Already errored");
        }
        this.errored = true;
        this.error = error;
        for (Consumer failure : this.promise.failures) {
            failure.accept(error);
        }
        if (this.promise.waiting) {
            MyPromise myPromise = this.promise;
            synchronized (myPromise) {
                this.promise.notifyAll();
            }
        }
        this.promise.cachedConsumers.clear();
        this.promise.consumers.clear();
        this.promise.failures.clear();
    }

    public Promise<T, S, E> promise() {
        return this.promise;
    }

    private class MyPromise
    implements Promise<T, S, E> {
        private LinkedList<Consumer<T>> consumers = new LinkedList();
        private LinkedList<Consumer<T>> cachedConsumers = new LinkedList();
        private LinkedList<Consumer<E>> failures = new LinkedList();
        private LinkedList<Consumer<S>> statusReceivers = new LinkedList();
        private boolean waiting = false;

        private MyPromise() {
        }

        @Override
        public Class<E> getErrorClass() {
            return Deferred.this.errorClass;
        }

        @Override
        public Promise<T, S, E> onDone(Consumer<T> consumer) {
            if (!Deferred.this.errored & !Deferred.this.resolved) {
                this.consumers.add(consumer);
            } else if (Deferred.this.resolved) {
                Deferred.this.runner.accept(() -> consumer.accept(Deferred.this.result));
            }
            return this;
        }

        @Override
        public Promise<T, S, E> onCached(Consumer<T> consumer) {
            if (!(Deferred.this.errored || Deferred.this.resolved || Deferred.this.cached)) {
                this.cachedConsumers.add(consumer);
            } else {
                Deferred.this.runner.accept(() -> consumer.accept(Deferred.this.cachedValue));
            }
            return this;
        }

        @Override
        public Promise<T, S, E> onStatus(Consumer<S> consumer) {
            this.statusReceivers.add(consumer);
            return this;
        }

        @Override
        public Promise<T, S, E> onFail(Consumer<E> consumer) {
            if (Deferred.this.error == null) {
                this.failures.add(consumer);
            } else if (Deferred.this.errored) {
                Deferred.this.runner.accept(() -> consumer.accept(Deferred.this.error));
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws Throwable {
            while (!Deferred.this.resolved) {
                if (Deferred.this.errored) {
                    throw Deferred.this.error;
                }
                try {
                    MyPromise myPromise = this;
                    synchronized (myPromise) {
                        this.waiting = true;
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return Deferred.this.result;
        }
    }
}

