/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import org.openzen.zengarden.events.EventBus;
import org.openzen.zengarden.events.EventListener;
import org.openzen.zengarden.events.ListenerHandle;
import org.openzen.zengarden.watched.WatchedValue;
import org.openzen.zengarden.watched.event.AfterChangeEvent;
import org.openzen.zengarden.watched.event.BeforeChangeEvent;
import org.openzen.zengarden.watched.event.ChangeEvent;

public abstract class AbstractWatchedValue<T>
implements WatchedValue<T> {
    private final EventBus<ChangeEvent> events = new EventBus();

    protected boolean onBeforeChange(T oldValue, T newValue) {
        BeforeChangeEvent<T> event = new BeforeChangeEvent<T>(oldValue, newValue);
        this.events.publish(event);
        return !event.isCanceled();
    }

    protected void onChanged(T oldValue, T newValue) {
        this.events.publish(new AfterChangeEvent<T>(oldValue, newValue));
    }

    @Override
    public ListenerHandle<?> whenGoingToChange(EventListener<BeforeChangeEvent<T>> listener) {
        Class<BeforeChangeEvent> cls = BeforeChangeEvent.class;
        return this.events.add(listener, cls);
    }

    @Override
    public ListenerHandle<?> whenChanged(EventListener<AfterChangeEvent<T>> listener) {
        Class<AfterChangeEvent> cls = AfterChangeEvent.class;
        return this.events.add(listener, cls);
    }
}

