/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class ByteArrayFunctions
implements ArrayFunctions<byte[]> {
    public static final ByteArrayFunctions INSTANCE = new ByteArrayFunctions();

    private ByteArrayFunctions() {
    }

    @Override
    public byte[] newArray(int length) {
        return new byte[length];
    }

    @Override
    public int getLength(byte[] value) {
        return value.length;
    }

    @Override
    public boolean equals(byte[] array1, byte[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public byte[] concat(byte[] array1, byte[] array2) {
        byte[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(byte[] array, byte[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(byte[] array, byte[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(byte[] array1, byte[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(byte[] array1, byte[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public byte[] copyOfRange(byte[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(byte[] from, int fromOffset, byte[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(byte[] array1, int array1Index, byte[] array2, int array2Index) {
        return array1[array1Index] == array2[array2Index];
    }

    @Override
    public void write(DataOutput output, byte[] value) throws IOException {
        output.writeByteArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, byte[] value) throws IOException {
        output.writeRawBytes(value);
    }

    @Override
    public void write(BytesDataOutput output, byte[] value) {
        output.writeByteArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, byte[] value) {
        output.writeRawBytes(value);
    }

    @Override
    public byte[] read(DataInput input) throws IOException {
        return input.readByteArray();
    }

    @Override
    public byte[] readRaw(DataInput input, int length) throws IOException {
        return input.readRawBytes(length);
    }

    @Override
    public byte[] read(BytesDataInput input) {
        return input.readByteArray();
    }

    @Override
    public byte[] readRaw(BytesDataInput input, int length) {
        return input.readRawBytes(length);
    }
}

