/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.promise;

import java.util.LinkedList;
import java.util.List;
import org.openzen.zengarden.function.Consumer;
import org.openzen.zengarden.function.ErrorableFunction;
import org.openzen.zengarden.promise.Promise;

public class ProcessedPromise<R, R2, S, E extends Throwable>
implements Promise<R2, S, E> {
    private final List<Consumer<R2>> consumers = new LinkedList<Consumer<R2>>();
    private final List<Consumer<R2>> cachedConsumers = new LinkedList<Consumer<R2>>();
    private final List<Consumer<E>> errorConsumers = new LinkedList<Consumer<E>>();
    private final Promise<R, S, E> originalPromise;
    private final ErrorableFunction<R, R2, E> processor;
    private boolean cached = false;
    private R2 cachedValue;
    private boolean resolved = false;
    private R2 result;
    private boolean errored = false;
    private E error;

    public ProcessedPromise(Promise<R, S, E> originalPromise, ErrorableFunction<R, R2, E> processor) {
        this.originalPromise = originalPromise;
        this.processor = processor;
        originalPromise.onDone(r -> {
            try {
                this.resolved = true;
                this.result = processor.apply(r);
                for (Consumer<R2> consumer : this.consumers) {
                    consumer.accept(this.result);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        });
        originalPromise.onCached(c -> {
            try {
                this.cached = true;
                this.cachedValue = processor.apply(c);
                for (Consumer<R2> consumer : this.cachedConsumers) {
                    consumer.accept(this.cachedValue);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        });
        originalPromise.onFail(e -> this.exception((Throwable)e));
    }

    private void exception(Throwable exception) {
        try {
            this.error = exception;
            for (Consumer<E> consumer : this.errorConsumers) {
                consumer.accept(this.error);
            }
        }
        catch (ClassCastException ex) {
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    @Override
    public Class<E> getErrorClass() {
        return this.originalPromise.getErrorClass();
    }

    @Override
    public Promise<R2, S, E> onDone(Consumer<R2> consumer) {
        if (this.resolved) {
            consumer.accept(this.result);
        } else {
            this.consumers.add(consumer);
        }
        return this;
    }

    @Override
    public Promise<R2, S, E> onCached(Consumer<R2> consumer) {
        if (this.cached) {
            consumer.accept(this.cachedValue);
        } else {
            this.cachedConsumers.add(consumer);
        }
        return this;
    }

    @Override
    public Promise<R2, S, E> onStatus(Consumer<S> consumer) {
        this.originalPromise.onStatus(consumer);
        return this;
    }

    @Override
    public Promise<R2, S, E> onFail(Consumer<E> consumer) {
        this.originalPromise.onFail(consumer);
        return this;
    }

    @Override
    public R2 get() throws E {
        if (this.resolved) {
            return this.result;
        }
        return this.processor.apply(this.originalPromise.get());
    }
}

