/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class IntArrayFunctions
implements ArrayFunctions<int[]> {
    public static final IntArrayFunctions INSTANCE = new IntArrayFunctions();

    protected IntArrayFunctions() {
    }

    @Override
    public int[] newArray(int length) {
        return new int[length];
    }

    @Override
    public int getLength(int[] value) {
        return value.length;
    }

    @Override
    public boolean equals(int[] array1, int[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public int[] concat(int[] array1, int[] array2) {
        int[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(int[] array, int[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(int[] array, int[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(int[] array1, int[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(int[] array1, int[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public int[] copyOfRange(int[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(int[] from, int fromOffset, int[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(int[] array1, int array1Index, int[] array2, int array2Index) {
        return array1[array1Index] == array2[array2Index];
    }

    @Override
    public void write(DataOutput output, int[] value) throws IOException {
        output.writeIntArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, int[] value) throws IOException {
        output.writeIntArrayRaw(value);
    }

    @Override
    public void write(BytesDataOutput output, int[] value) {
        output.writeIntArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, int[] value) {
        output.writeIntArrayRaw(value);
    }

    @Override
    public int[] read(DataInput input) throws IOException {
        return input.readIntArray();
    }

    @Override
    public int[] readRaw(DataInput input, int length) throws IOException {
        return input.readIntArray(length);
    }

    @Override
    public int[] read(BytesDataInput input) {
        return input.readIntArray();
    }

    @Override
    public int[] readRaw(BytesDataInput input, int length) {
        return input.readIntArray(length);
    }
}

