/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class ShortArrayFunctions
implements ArrayFunctions<short[]> {
    public static final ShortArrayFunctions INSTANCE = new ShortArrayFunctions();

    private ShortArrayFunctions() {
    }

    @Override
    public short[] newArray(int length) {
        return new short[length];
    }

    @Override
    public int getLength(short[] value) {
        return value.length;
    }

    @Override
    public boolean equals(short[] array1, short[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public short[] concat(short[] array1, short[] array2) {
        short[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(short[] array, short[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(short[] array, short[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(short[] array1, short[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(short[] array1, short[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public short[] copyOfRange(short[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(short[] from, int fromOffset, short[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(short[] array1, int array1Index, short[] array2, int array2Index) {
        return array1[array1Index] == array2[array2Index];
    }

    @Override
    public void write(DataOutput output, short[] value) throws IOException {
        output.writeShortArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, short[] value) throws IOException {
        output.writeShortArrayRaw(value);
    }

    @Override
    public void write(BytesDataOutput output, short[] value) {
        output.writeShortArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, short[] value) {
        output.writeShortArrayRaw(value);
    }

    @Override
    public short[] read(DataInput input) throws IOException {
        return input.readShortArray();
    }

    @Override
    public short[] readRaw(DataInput input, int length) throws IOException {
        return input.readShortArray(length);
    }

    @Override
    public short[] read(BytesDataInput input) {
        return input.readShortArray();
    }

    @Override
    public short[] readRaw(BytesDataInput input, int length) {
        return input.readShortArray(length);
    }
}

