/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class FloatArrayFunctions
implements ArrayFunctions<float[]> {
    public static final FloatArrayFunctions INSTANCE = new FloatArrayFunctions();

    protected FloatArrayFunctions() {
    }

    @Override
    public float[] newArray(int length) {
        return new float[length];
    }

    @Override
    public int getLength(float[] value) {
        return value.length;
    }

    @Override
    public boolean equals(float[] array1, float[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public float[] concat(float[] array1, float[] array2) {
        float[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(float[] array, float[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(float[] array, float[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(float[] array1, float[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(float[] array1, float[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public float[] copyOfRange(float[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(float[] from, int fromOffset, float[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(float[] array1, int array1Index, float[] array2, int array2Index) {
        return array1[array1Index] == array2[array2Index];
    }

    @Override
    public void write(DataOutput output, float[] value) throws IOException {
        output.writeFloatArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, float[] value) throws IOException {
        output.writeFloatArrayRaw(value);
    }

    @Override
    public void write(BytesDataOutput output, float[] value) {
        output.writeFloatArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, float[] value) {
        output.writeFloatArrayRaw(value);
    }

    @Override
    public float[] read(DataInput input) throws IOException {
        return input.readFloatArray();
    }

    @Override
    public float[] readRaw(DataInput input, int length) throws IOException {
        return input.readFloatArray(length);
    }

    @Override
    public float[] read(BytesDataInput input) {
        return input.readFloatArray();
    }

    @Override
    public float[] readRaw(BytesDataInput input, int length) {
        return input.readFloatArray(length);
    }
}

