/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class StringArrayFunctions
implements ArrayFunctions<String[]> {
    public static final StringArrayFunctions INSTANCE = new StringArrayFunctions();

    protected StringArrayFunctions() {
    }

    @Override
    public String[] newArray(int length) {
        return new String[length];
    }

    @Override
    public int getLength(String[] value) {
        return value.length;
    }

    @Override
    public boolean equals(String[] array1, String[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public String[] concat(String[] array1, String[] array2) {
        String[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(String[] array, String[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i].equals(subarray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String[] array, String[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i].equals(subarray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(String[] array1, String[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(String[] array1, String[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public String[] copyOfRange(String[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(String[] from, int fromOffset, String[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(String[] array1, int array1Index, String[] array2, int array2Index) {
        return array1[array1Index].equals(array2[array2Index]);
    }

    @Override
    public void write(DataOutput output, String[] value) throws IOException {
        output.writeStringArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, String[] value) throws IOException {
        output.writeStringArrayRaw(value);
    }

    @Override
    public void write(BytesDataOutput output, String[] value) {
        output.writeStringArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, String[] value) {
        output.writeStringArrayRaw(value);
    }

    @Override
    public String[] read(DataInput input) throws IOException {
        return input.readStringArray();
    }

    @Override
    public String[] readRaw(DataInput input, int length) throws IOException {
        return input.readStringArray(length);
    }

    @Override
    public String[] read(BytesDataInput input) {
        return input.readStringArray();
    }

    @Override
    public String[] readRaw(BytesDataInput input, int length) {
        return input.readStringArray(length);
    }
}

