/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class LongArrayFunctions
implements ArrayFunctions<long[]> {
    public static final LongArrayFunctions INSTANCE = new LongArrayFunctions();

    protected LongArrayFunctions() {
    }

    @Override
    public long[] newArray(int length) {
        return new long[length];
    }

    @Override
    public int getLength(long[] value) {
        return value.length;
    }

    @Override
    public boolean equals(long[] array1, long[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public long[] concat(long[] array1, long[] array2) {
        long[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(long[] array, long[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(long[] array, long[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(long[] array1, long[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(long[] array1, long[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public long[] copyOfRange(long[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(long[] from, int fromOffset, long[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(long[] array1, int array1Index, long[] array2, int array2Index) {
        return array1[array1Index] == array2[array2Index];
    }

    @Override
    public void write(DataOutput output, long[] value) throws IOException {
        output.writeLongArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, long[] value) throws IOException {
        output.writeLongArrayRaw(value);
    }

    @Override
    public void write(BytesDataOutput output, long[] value) {
        output.writeLongArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, long[] value) {
        output.writeLongArrayRaw(value);
    }

    @Override
    public long[] read(DataInput input) throws IOException {
        return input.readLongArray();
    }

    @Override
    public long[] readRaw(DataInput input, int length) throws IOException {
        return input.readLongArray(length);
    }

    @Override
    public long[] read(BytesDataInput input) {
        return input.readLongArray();
    }

    @Override
    public long[] readRaw(BytesDataInput input, int length) {
        return input.readLongArray(length);
    }
}

