/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import org.openzen.zengarden.collections.ZList;
import org.openzen.zengarden.function.Predicate;
import org.openzen.zengarden.util.ZObjects;

public class ZArrayList<T>
implements ZList<T> {
    private final Class<T> type;
    private T[] values;
    private int size;

    public ZArrayList(Class<T> type) {
        this(type, 16);
    }

    public ZArrayList(Class<T> type, int initialSize) {
        this.type = type;
        this.values = (Object[])Array.newInstance(type, initialSize);
    }

    @Override
    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " (size = " + this.size + ")");
        }
        return this.values[index];
    }

    @Override
    public T set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " (size = " + this.size + ")");
        }
        T result = this.values[index];
        this.values[index] = value;
        return result;
    }

    @Override
    public int indexOf(T value) {
        for (int i = 0; i < this.size; ++i) {
            if (!ZObjects.equals(this.values[i], value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(T value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!ZObjects.equals(this.values[i], value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<T> getElementClass() {
        return this.type;
    }

    @Override
    public boolean add(T value) {
        if (this.size == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        }
        this.values[this.size++] = value;
        return true;
    }

    @Override
    public boolean add(int index, T value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        }
        for (int i = this.size; i > index; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[index] = value;
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(T value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public T remove(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        T result = this.values[index];
        for (int i = index; i < this.size - 1; ++i) {
            this.values[i] = this.values[i + 1];
        }
        return result;
    }

    @Override
    public boolean removeAll(Predicate<T> predicate) {
        int removed = 0;
        for (int i = 0; i < this.size; ++i) {
            if (predicate.test(this.values[i])) {
                ++removed;
                continue;
            }
            this.values[i - removed] = this.values[i];
        }
        this.size -= removed;
        return removed > 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.values = (Object[])Array.newInstance(this.type, this.size);
        this.size = 0;
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.values[i]);
        }
    }

    @Override
    public T[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    private class ArrayIterator
    implements Iterator<T> {
        private int index = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ZArrayList.this.size;
        }

        @Override
        public T next() {
            return ZArrayList.this.values[this.index++];
        }

        @Override
        public void remove() {
            ZArrayList.this.remove(this.index - 1);
        }
    }
}

