/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.time.LocalDate;
import java.util.Arrays;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.util.Charsets;
import org.openzen.zengarden.util.FlexDateTime;

public class BytesDataInput
implements DataInput {
    private static final int P6 = 64;
    private static final int P7 = 128;
    private static final int P13 = 8192;
    private static final int P14 = 16384;
    private static final int P20 = 0x100000;
    private static final int P21 = 0x200000;
    private static final int P27 = 0x8000000;
    private static final int P28 = 0x10000000;
    private static final long P34 = 0x400000000L;
    private static final long P35 = 0x800000000L;
    private static final long P41 = 0x20000000000L;
    private static final long P42 = 0x40000000000L;
    private static final long P48 = 0x1000000000000L;
    private static final long P49 = 0x2000000000000L;
    private static final long P55 = 0x80000000000000L;
    private static final long P56 = 0x100000000000000L;
    private byte[] data;
    private int index;

    public BytesDataInput(byte[] data) {
        this.data = data;
        this.index = 0;
    }

    public BytesDataInput(byte[] data, int offset) {
        this.data = data;
        this.index = offset;
    }

    public int getCurrentOffset() {
        return this.index;
    }

    @Override
    public boolean readBoolean() {
        return this.readUByte() != 0;
    }

    @Override
    public byte readSByte() {
        return this.data[this.index++];
    }

    @Override
    public int readUByte() {
        return this.data[this.index++] & 0xFF;
    }

    @Override
    public short readShort() {
        int b0 = this.data[this.index++] & 0xFF;
        int b1 = this.data[this.index++] & 0xFF;
        return (short)(b0 << 8 | b1);
    }

    @Override
    public int readUShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() {
        int b0 = this.data[this.index++] & 0xFF;
        int b1 = this.data[this.index++] & 0xFF;
        int b2 = this.data[this.index++] & 0xFF;
        int b3 = this.data[this.index++] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    @Override
    public int readUInt() {
        return this.readInt();
    }

    @Override
    public long readLong() {
        long i0 = (long)this.readInt() & 0xFFFFFFFFL;
        long i1 = (long)this.readInt() & 0xFFFFFFFFL;
        return i0 << 32 | i1;
    }

    @Override
    public long readULong() {
        return this.readLong();
    }

    @Override
    public int readVarInt() {
        int value;
        if (((value = this.data[this.index++] & 0xFF) & 0x80) == 0) {
            return value - 64;
        }
        if (((value = value & 0x7F | (this.data[this.index++] & 0xFF) << 7) & 0x4000) == 0) {
            return value - 8192;
        }
        if (((value = value & 0x3FFF | (this.data[this.index++] & 0xFF) << 14) & 0x200000) == 0) {
            return value - 0x100000;
        }
        if (((value = value & 0x1FFFFF | (this.data[this.index++] & 0xFF) << 21) & 0x10000000) == 0) {
            return value - 0x8000000;
        }
        return value & 0xFFFFFFF | (this.data[this.index++] & 0xFF) << 28;
    }

    @Override
    public int readVarUInt() {
        int value;
        if (((value = this.data[this.index++] & 0xFF) & 0x80) == 0) {
            return value;
        }
        if (((value = value & 0x7F | (this.data[this.index++] & 0xFF) << 7) & 0x4000) == 0) {
            return value;
        }
        if (((value = value & 0x3FFF | (this.data[this.index++] & 0xFF) << 14) & 0x200000) == 0) {
            return value;
        }
        if (((value = value & 0x1FFFFF | (this.data[this.index++] & 0xFF) << 21) & 0x10000000) == 0) {
            return value;
        }
        return value & 0xFFFFFFF | (this.data[this.index++] & 0xFF) << 28;
    }

    @Override
    public long readVarLong() {
        long value;
        if (((value = (long)(this.data[this.index++] & 0xFF)) & 0x80L) == 0L) {
            return value - 64L;
        }
        if (((value = value & 0x7FL | (long)((this.data[this.index++] & 0xFF) << 7)) & 0x4000L) == 0L) {
            return value - 8192L;
        }
        if (((value = value & 0x3FFFL | (long)((this.data[this.index++] & 0xFF) << 14)) & 0x200000L) == 0L) {
            return value - 0x100000L;
        }
        if (((value = value & 0x1FFFFFL | (long)((this.data[this.index++] & 0xFF) << 21)) & 0x10000000L) == 0L) {
            return value - 0x8000000L;
        }
        if (((value = value & 0xFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 28) & 0x800000000L) == 0L) {
            return value - 0x400000000L;
        }
        if (((value = value & 0x7FFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 35) & 0x40000000000L) == 0L) {
            return value - 0x20000000000L;
        }
        if (((value = value & 0x3FFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 42) & 0x2000000000000L) == 0L) {
            return value - 0x1000000000000L;
        }
        if (((value = value & 0x1FFFFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 49) & 0x100000000000000L) == 0L) {
            return value - 0x80000000000000L;
        }
        return value & 0xFFFFFFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 56;
    }

    @Override
    public long readVarULong() {
        long value;
        if (((value = (long)(this.data[this.index++] & 0xFF)) & 0x80L) == 0L) {
            return value;
        }
        if (((value = value & 0x7FL | (long)((this.data[this.index++] & 0xFF) << 7)) & 0x4000L) == 0L) {
            return value;
        }
        if (((value = value & 0x3FFFL | (long)((this.data[this.index++] & 0xFF) << 14)) & 0x200000L) == 0L) {
            return value;
        }
        if (((value = value & 0x1FFFFFL | (long)((this.data[this.index++] & 0xFF) << 21)) & 0x10000000L) == 0L) {
            return value;
        }
        if (((value = value & 0xFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 28) & 0x800000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x7FFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 35) & 0x40000000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x3FFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 42) & 0x2000000000000L) == 0L) {
            return value;
        }
        if (((value = value & 0x1FFFFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 49) & 0x100000000000000L) == 0L) {
            return value;
        }
        return value & 0xFFFFFFFFFFFFFFL | ((long)this.data[this.index++] & 0xFFL) << 56;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int readChar() {
        return this.readVarUInt();
    }

    @Override
    public String readString() {
        int size = this.readVarUInt();
        return new String(this.readRawBytes(size), Charsets.UTF_8);
    }

    @Override
    public byte[] readBytes() {
        int size = this.readVarUInt();
        return this.readRawBytes(size);
    }

    @Override
    public byte[] readRawBytes(int size) {
        byte[] result = Arrays.copyOfRange(this.data, this.index, this.index + size);
        this.index += size;
        return result;
    }

    @Override
    public boolean[] readBoolArray() {
        int size = this.readVarUInt();
        boolean[] result = new boolean[size];
        for (int i = 0; i < (size + 7) / 8; ++i) {
            int bvalue = this.readUByte();
            int remainingBits = result.length - 8 * i;
            if (remainingBits > 0) {
                boolean bl = result[i * 8 + 0] = (bvalue & 1) > 0;
            }
            if (remainingBits > 1) {
                boolean bl = result[i * 8 + 1] = (bvalue & 2) > 0;
            }
            if (remainingBits > 2) {
                boolean bl = result[i * 8 + 2] = (bvalue & 4) > 0;
            }
            if (remainingBits > 3) {
                boolean bl = result[i * 8 + 3] = (bvalue & 8) > 0;
            }
            if (remainingBits > 4) {
                boolean bl = result[i * 8 + 4] = (bvalue & 0x10) > 0;
            }
            if (remainingBits > 5) {
                boolean bl = result[i * 8 + 5] = (bvalue & 0x20) > 0;
            }
            if (remainingBits > 6) {
                boolean bl = result[i * 8 + 6] = (bvalue & 0x40) > 0;
            }
            if (remainingBits <= 7) continue;
            result[i * 8 + 7] = (bvalue & 0x80) > 0;
        }
        return result;
    }

    @Override
    public byte[] readByteArray() {
        return this.readBytes();
    }

    @Override
    public byte[] readUByteArray() {
        return this.readBytes();
    }

    @Override
    public short[] readShortArray() {
        return this.readShortArray(this.readVarUInt());
    }

    @Override
    public short[] readShortArray(int length) {
        short[] result = new short[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    @Override
    public short[] readUShortArray() {
        return this.readShortArray();
    }

    @Override
    public short[] readUShortArray(int length) {
        return this.readShortArray(length);
    }

    @Override
    public int[] readVarIntArray() {
        return this.readVarIntArray(this.readVarUInt());
    }

    @Override
    public int[] readVarIntArray(int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarInt();
        }
        return result;
    }

    @Override
    public int[] readVarUIntArray() {
        return this.readVarUIntArray(this.readVarUInt());
    }

    @Override
    public int[] readVarUIntArray(int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarUInt();
        }
        return result;
    }

    @Override
    public int[] readIntArray() {
        return this.readIntArray(this.readVarUInt());
    }

    @Override
    public int[] readIntArray(int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    @Override
    public int[] readUIntArray() {
        int[] result = new int[this.readVarUInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readUInt();
        }
        return result;
    }

    @Override
    public long[] readVarLongArray() {
        return this.readVarLongArray(this.readVarUInt());
    }

    @Override
    public long[] readVarLongArray(int length) {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarLong();
        }
        return result;
    }

    @Override
    public long[] readVarULongArray() {
        return this.readVarULongArray(this.readVarUInt());
    }

    @Override
    public long[] readVarULongArray(int length) {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readVarULong();
        }
        return result;
    }

    @Override
    public long[] readLongArray() {
        return this.readLongArray(this.readVarUInt());
    }

    @Override
    public long[] readLongArray(int length) {
        long[] result = new long[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readLong();
        }
        return result;
    }

    @Override
    public long[] readULongArray() {
        return this.readLongArray();
    }

    @Override
    public long[] readULongArray(int length) {
        return this.readLongArray(length);
    }

    @Override
    public float[] readFloatArray() {
        return this.readFloatArray(this.readVarUInt());
    }

    @Override
    public float[] readFloatArray(int length) {
        float[] result = new float[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    @Override
    public double[] readDoubleArray() {
        return this.readDoubleArray(this.readVarUInt());
    }

    @Override
    public double[] readDoubleArray(int length) {
        double[] result = new double[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readDouble();
        }
        return result;
    }

    @Override
    public String[] readStringArray() {
        return this.readStringArray(this.readVarUInt());
    }

    @Override
    public String[] readStringArray(int length) {
        String[] result = new String[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readString();
        }
        return result;
    }

    @Override
    public LocalDate readDate() {
        int value = this.readVarInt();
        if (value == -32) {
            return null;
        }
        int year = value / 372 + 2000;
        int monthsAndDays = value % 372;
        if (value < 0) {
            --year;
            monthsAndDays += 372;
        }
        int month = monthsAndDays / 31;
        int day = monthsAndDays % 31;
        return LocalDate.of(year, month + 1, day + 1);
    }

    @Override
    public FlexDateTime readFlexDateTime() {
        return new FlexDateTime(this.readULong());
    }

    @Override
    public void skip(int bytes) {
        this.index += bytes;
    }

    @Override
    public boolean hasMore() {
        return this.index < this.data.length;
    }

    @Override
    public void close() {
    }
}

