/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.util;

import java.util.Arrays;
import java.util.Base64;
import java.util.Random;

public class ZID {
    private static final Random RANDOM = new Random();
    private final byte[] bytes;
    private final int hash;

    public static ZID random() {
        byte[] id = new byte[16];
        RANDOM.nextBytes(id);
        return new ZID(id);
    }

    public static ZID fromString(String id) {
        return new ZID(Base64.getDecoder().decode(id));
    }

    public ZID(byte[] bytes) {
        this.bytes = bytes;
        this.hash = Arrays.hashCode(bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZID other = (ZID)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

