/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.arrays;

import java.io.IOException;
import java.util.Arrays;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class DoubleArrayFunctions
implements ArrayFunctions<double[]> {
    public static final DoubleArrayFunctions INSTANCE = new DoubleArrayFunctions();

    protected DoubleArrayFunctions() {
    }

    @Override
    public double[] newArray(int length) {
        return new double[length];
    }

    @Override
    public int getLength(double[] value) {
        return value.length;
    }

    @Override
    public boolean equals(double[] array1, double[] array2) {
        return Arrays.equals(array1, array2);
    }

    @Override
    public double[] concat(double[] array1, double[] array2) {
        double[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Override
    public boolean startsWith(double[] array, double[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(double[] array, double[] subarray) {
        if (subarray.length > array.length) {
            return false;
        }
        if (subarray.length == array.length) {
            return Arrays.equals(array, subarray);
        }
        for (int i = 0; i < subarray.length; ++i) {
            if (array[i] == subarray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCommonSuffixLength(double[] array1, double[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[array1.length - result - 1] == array2[array2.length - result - 1]; ++result) {
        }
        return result;
    }

    @Override
    public int getCommonPrefixLength(double[] array1, double[] array2) {
        int result;
        int limit = Math.min(array1.length, array2.length);
        for (result = 0; result < limit && array1[result] == array2[result]; ++result) {
        }
        return result;
    }

    @Override
    public double[] copyOfRange(double[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Override
    public void copyArray(double[] from, int fromOffset, double[] to, int toOffset, int length) {
        System.arraycopy(from, fromOffset, to, toOffset, length);
    }

    @Override
    public boolean equals(double[] array1, int array1Index, double[] array2, int array2Index) {
        return array1[array1Index] == array2[array2Index];
    }

    @Override
    public void write(DataOutput output, double[] value) throws IOException {
        output.writeDoubleArray(value);
    }

    @Override
    public void writeRaw(DataOutput output, double[] value) throws IOException {
        output.writeDoubleArrayRaw(value);
    }

    @Override
    public void write(BytesDataOutput output, double[] value) {
        output.writeDoubleArray(value);
    }

    @Override
    public void writeRaw(BytesDataOutput output, double[] value) {
        output.writeDoubleArrayRaw(value);
    }

    @Override
    public double[] read(DataInput input) throws IOException {
        return input.readDoubleArray();
    }

    @Override
    public double[] readRaw(DataInput input, int length) throws IOException {
        return input.readDoubleArray(length);
    }

    @Override
    public double[] read(BytesDataInput input) {
        return input.readDoubleArray();
    }

    @Override
    public double[] readRaw(BytesDataInput input, int length) {
        return input.readDoubleArray(length);
    }
}

