/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.openzen.zengarden.function.Function;

public class MappedCollection<T, U>
implements Collection<U> {
    private final Collection<T> original;
    private final Function<T, U> function;
    private final Function<U, T> backwardsFunction;

    public MappedCollection(Collection<T> original, Function<T, U> function) {
        this(original, function, null);
    }

    public MappedCollection(Collection<T> original, Function<T, U> function, Function<U, T> backwardsFunction) {
        this.original = original;
        this.function = function;
        this.backwardsFunction = backwardsFunction;
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot check containment without backwards function");
        }
        return this.original.contains(this.backwardsFunction.apply(o));
    }

    @Override
    public Iterator<U> iterator() {
        return new MappedIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (U value : this) {
            result[i] = value;
        }
        return result;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        for (U value : this) {
            a[i] = value;
        }
        return a;
    }

    @Override
    public boolean add(U e) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot add without backwards function");
        }
        return this.original.add(this.backwardsFunction.apply(e));
    }

    @Override
    public boolean remove(Object o) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot remove without backwards function");
        }
        return this.original.remove(this.backwardsFunction.apply(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.original.containsAll(new MappedCollection(c, this.backwardsFunction));
    }

    @Override
    public boolean addAll(Collection<? extends U> c) {
        if (this.backwardsFunction == null) {
            throw new UnsupportedOperationException("Cannot add without backwards function");
        }
        boolean result = false;
        for (U value : c) {
            result |= this.original.add(this.backwardsFunction.apply(value));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.original.removeAll(new MappedCollection(c, this.backwardsFunction));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.original.retainAll(new MappedCollection(c, this.backwardsFunction));
    }

    @Override
    public void clear() {
        this.original.clear();
    }

    private class MappedIterator
    implements Iterator<U> {
        private final Iterator<T> originalIterator;

        private MappedIterator() {
            this.originalIterator = MappedCollection.this.original.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.originalIterator.hasNext();
        }

        @Override
        public U next() {
            return MappedCollection.this.function.apply(this.originalIterator.next());
        }

        @Override
        public void remove() {
            this.originalIterator.remove();
        }
    }
}

