/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.util.Iterator;
import org.openzen.zengarden.collections.ZList;

public class ZEmptyList<T>
implements ZList<T> {
    private final Class<T> cls;
    private final Iterator<T> iterator = new EmptyIterator();

    public ZEmptyList(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public Class<T> getElementClass() {
        return this.cls;
    }

    @Override
    public boolean add(T value) {
        throw new UnsupportedOperationException("Cannot add to an empty list");
    }

    @Override
    public boolean remove(T value) {
        return false;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public boolean add(int index, T value) {
        throw new UnsupportedOperationException("Cannot add to an empty list");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot remove from an empty list");
    }

    @Override
    public T get(int index) {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public T set(int index, T value) {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int indexOf(T value) {
        return -1;
    }

    @Override
    public int lastIndexOf(T value) {
        return -1;
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new IndexOutOfBoundsException("Empty list!");
        }

        @Override
        public void remove() {
        }
    }
}

