/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.util.Iterator;
import org.openzen.zengarden.collections.ZList;
import org.openzen.zengarden.util.ZArrays;

public class ZFixedList<T>
implements ZList<T> {
    private final T[] contents;

    public ZFixedList(T[] contents) {
        this.contents = contents;
    }

    @Override
    public boolean add(int index, T value) {
        throw new UnsupportedOperationException("Cannot modify a fixed list");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot modify a fixed list");
    }

    @Override
    public T get(int index) {
        return this.contents[index];
    }

    @Override
    public T set(int index, T value) {
        T result = this.contents[index];
        this.contents[index] = value;
        return result;
    }

    @Override
    public int indexOf(T value) {
        return ZArrays.indexOf(this.contents, value);
    }

    @Override
    public int lastIndexOf(T value) {
        return ZArrays.lastIndexOf(this.contents, value);
    }

    @Override
    public Class<T> getElementClass() {
        return this.contents.getClass().getComponentType();
    }

    @Override
    public boolean add(T value) {
        throw new UnsupportedOperationException("Cannot modify a fixed list");
    }

    @Override
    public boolean remove(T value) {
        throw new UnsupportedOperationException("Cannot modify a fixed list");
    }

    @Override
    public boolean contains(T value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public int size() {
        return this.contents.length;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify a fixed list");
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    private class ArrayIterator
    implements Iterator<T> {
        private int index = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ZFixedList.this.contents.length;
        }

        @Override
        public T next() {
            return ZFixedList.this.contents[this.index++];
        }
    }
}

