/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.delta;

import java.io.IOException;
import java.util.Stack;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.arrays.ByteArrayFunctions;
import org.openzen.zengarden.arrays.DoubleArrayFunctions;
import org.openzen.zengarden.arrays.FloatArrayFunctions;
import org.openzen.zengarden.arrays.IntArrayFunctions;
import org.openzen.zengarden.arrays.LongArrayFunctions;
import org.openzen.zengarden.arrays.ShortArrayFunctions;
import org.openzen.zengarden.arrays.StringArrayFunctions;
import org.openzen.zengarden.arrays.VarIntArrayFunctions;
import org.openzen.zengarden.arrays.VarLongArrayFunctions;
import org.openzen.zengarden.arrays.VarUIntArrayFunctions;
import org.openzen.zengarden.arrays.VarULongArrayFunctions;
import org.openzen.zengarden.delta.ArrayDelta;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.DataInput;

public class ArrayDeltaBuilder<A> {
    public static final ArrayDeltaBuilder<byte[]> BYTE = new ArrayDeltaBuilder<byte[]>(ByteArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<short[]> SHORT = new ArrayDeltaBuilder<short[]>(ShortArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<int[]> INT = new ArrayDeltaBuilder<int[]>(IntArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<long[]> LONG = new ArrayDeltaBuilder<long[]>(LongArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<int[]> VARINT = new ArrayDeltaBuilder<int[]>(VarIntArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<int[]> VARUINT = new ArrayDeltaBuilder<int[]>(VarUIntArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<long[]> VARLONG = new ArrayDeltaBuilder<long[]>(VarLongArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<long[]> VARULONG = new ArrayDeltaBuilder<long[]>(VarULongArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<float[]> FLOAT = new ArrayDeltaBuilder<float[]>(FloatArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<double[]> DOUBLE = new ArrayDeltaBuilder<double[]>(DoubleArrayFunctions.INSTANCE);
    public static final ArrayDeltaBuilder<String[]> STRING = new ArrayDeltaBuilder<String[]>(StringArrayFunctions.INSTANCE);
    private final ArrayFunctions<A> functions;
    private static final int CHOICE_COPY = 1;
    private static final int CHOICE_SKIP = 2;
    private static final int CHOICE_INSERT = 3;
    private static final int DONT = 2147483547;

    public ArrayDeltaBuilder(ArrayFunctions<A> functions) {
        this.functions = functions;
    }

    public ArrayDelta<A> diff(A original, A modified) {
        if (this.functions.equals(original, modified)) {
            return this.getBuilder().copyUntilEnd();
        }
        if (this.functions.startsWith(modified, original)) {
            return this.getBuilder().copy(this.functions.getLength(original)).insert(this.functions.copyOfRange(modified, this.functions.getLength(original), this.functions.getLength(modified))).end();
        }
        if (this.functions.startsWith(original, modified)) {
            return this.getBuilder().copy(this.functions.getLength(modified)).end();
        }
        int commonPrefix = this.functions.getCommonPrefixLength(original, modified);
        int commonSuffix = this.functions.getCommonSuffixLength(original, modified);
        if ((this.functions.getLength(original) - commonPrefix - commonSuffix) * (this.functions.getLength(modified) - commonPrefix - commonSuffix) < 10000000) {
            return this.diffExact(original, modified, commonPrefix, commonSuffix);
        }
        return this.diffApproximate(original, modified, commonPrefix, commonSuffix);
    }

    private ArrayDelta<A> diffExact(A original, A modified, int commonHead, int commonTail) {
        int i;
        int originalCompareLength = this.functions.getLength(original) - commonHead - commonTail;
        int modifiedCompareLength = this.functions.getLength(modified) - commonHead - commonTail;
        int length = (originalCompareLength + 1) * (modifiedCompareLength + 1);
        int[] costsCopy = new int[length];
        int[] costsSkip = new int[length];
        int[] costsInsert = new int[length];
        int width = originalCompareLength + 1;
        costsCopy[0] = 0;
        costsSkip[0] = 0;
        costsInsert[0] = 0;
        for (i = 0; i < originalCompareLength; ++i) {
            costsCopy[i + 1] = 2147483547;
            costsSkip[i + 1] = 1;
            costsInsert[i + 1] = 2147483547;
        }
        for (i = 1; i <= modifiedCompareLength; ++i) {
            costsCopy[width * i] = 2147483547;
            costsSkip[width * i] = 2147483547;
            costsInsert[width * i] = i + 1;
        }
        for (i = 0; i < originalCompareLength; ++i) {
            for (int j = 0; j < modifiedCompareLength; ++j) {
                int offset = i + j * width + 1 + width;
                costsSkip[offset] = Math.min(costsSkip[offset - 1], Math.min(costsCopy[offset - 1], costsInsert[offset - 1]) + 1);
                costsInsert[offset] = Math.min(costsInsert[offset - width] + 1, Math.min(costsCopy[offset - width], costsSkip[offset - width]) + 2);
                costsCopy[offset] = this.functions.equals(original, commonHead + i, modified, commonHead + j) ? Math.min(costsCopy[offset - 1 - width], Math.min(costsSkip[offset - 1 - width], costsInsert[offset - 1 - width]) + 1) : 2147483547;
            }
        }
        Stack<Integer> choiceStack = new Stack<Integer>();
        int i2 = originalCompareLength;
        int j = modifiedCompareLength;
        while (i2 > 0 || j > 0) {
            int choice;
            int offset = i2 + j * width;
            int lowest = Math.min(costsSkip[offset], Math.min(costsInsert[offset], costsCopy[offset]));
            if (lowest == costsCopy[offset]) {
                --i2;
                --j;
                choice = 1;
            } else if (lowest == costsInsert[offset]) {
                --j;
                choice = 3;
            } else if (lowest == costsSkip[offset]) {
                --i2;
                choice = 2;
            } else {
                throw new AssertionError();
            }
            if (i2 < 0 || j < 0) {
                throw new AssertionError();
            }
            choiceStack.add(choice);
        }
        UpdateBuilder<A> builder = this.getBuilder();
        int currentChoice = -1;
        int currentChoiceLength = 0;
        int modifiedOffset = 0;
        if (commonHead > 0) {
            currentChoice = 1;
            currentChoiceLength = commonHead;
        }
        while (!choiceStack.isEmpty()) {
            int newChoice = (Integer)choiceStack.pop();
            if (newChoice != currentChoice) {
                if (currentChoice == 1) {
                    builder.copy(currentChoiceLength);
                    modifiedOffset += currentChoiceLength;
                } else if (currentChoice == 2) {
                    builder.skip(currentChoiceLength);
                } else if (currentChoice == 3) {
                    A value = this.functions.copyOfRange(modified, modifiedOffset, modifiedOffset + currentChoiceLength);
                    builder.insert(value);
                    modifiedOffset += currentChoiceLength;
                }
                currentChoiceLength = 0;
                currentChoice = newChoice;
            }
            ++currentChoiceLength;
        }
        if (currentChoice == 1) {
            return builder.copyUntilEnd();
        }
        if (currentChoice == 2) {
            if (commonTail > 0) {
                builder.skip(currentChoiceLength);
                return builder.copyUntilEnd();
            }
            return builder.end();
        }
        if (currentChoice == 3) {
            A value = this.functions.copyOfRange(modified, modifiedOffset, modifiedOffset + currentChoiceLength);
            builder.insert(value);
            if (commonTail > 0) {
                return builder.copyUntilEnd();
            }
            return builder.end();
        }
        throw new AssertionError();
    }

    private ArrayDelta<A> diffApproximate(A original, A modified, int commonHead, int commonTail) {
        return this.getBuilder().copy(commonHead).skip(this.functions.getLength(original) - commonHead - commonTail).insert(this.functions.copyOfRange(modified, commonHead, this.functions.getLength(modified) - commonTail)).copyUntilEnd();
    }

    public UpdateBuilder<A> getBuilder() {
        return new UpdateBuilder(this.functions);
    }

    public ArrayDelta<A> read(DataInput input) throws IOException {
        return new ArrayDelta<A>(this.functions, input);
    }

    public static class UpdateBuilder<A> {
        private final ArrayFunctions<A> functions;
        private final BytesDataOutput output = new BytesDataOutput();

        private UpdateBuilder(ArrayFunctions<A> functions) {
            this.functions = functions;
        }

        public UpdateBuilder<A> insert(A array) {
            if (this.functions.getLength(array) == 0) {
                return this;
            }
            this.output.writeVarUInt(this.functions.getLength(array) << 2);
            this.functions.writeRaw(this.output, array);
            return this;
        }

        public UpdateBuilder<A> copy(int length) {
            if (length == 0) {
                return this;
            }
            this.output.writeVarUInt(length << 2 | 1);
            return this;
        }

        public UpdateBuilder<A> skip(int bytes) {
            if (bytes == 0) {
                return this;
            }
            this.output.writeVarUInt(bytes << 2 | 2);
            return this;
        }

        public UpdateBuilder<A> copyFrom(int position, int bytes) {
            if (bytes == 0) {
                return this;
            }
            this.output.writeVarUInt(2);
            this.output.writeVarUInt(position);
            this.output.writeVarUInt(bytes);
            return this;
        }

        public ArrayDelta<A> copyUntilEnd() {
            this.output.writeVarUInt(1);
            return this.build();
        }

        public ArrayDelta<A> end() {
            this.output.writeVarUInt(3);
            return this.build();
        }

        private ArrayDelta<A> build() {
            return new ArrayDelta<A>(this.functions, this.output.toByteArray());
        }
    }
}

